/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ui;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.utoolity.atlassian.dry.AUIMessage;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.dry.PluginInfo;
import net.utoolity.atlassian.ifaws.AWSConsoleLoginConnectorFilter;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AWSConsoleLinkSelectionServlet
extends HttpServlet {
    public static final String AWS_CONNECTOR_OVERVIEW_SERVLET_PATH = "/plugins/servlet/identity-federation-for-aws/configuration/aws-connector";
    private static final long serialVersionUID = 1L;
    private final LicenseHelper licenseHelper;
    private final TemplateRenderer renderer;
    private final I18nResolver i18n;
    private final AWSConnectorService2 awsConnectorService2;

    @Autowired
    public AWSConsoleLinkSelectionServlet(LicenseHelper licenseHelper, @ComponentImport TemplateRenderer renderer, @ComponentImport I18nResolver i18n, AWSConnectorService2 awsConnectorService2) {
        this.licenseHelper = licenseHelper;
        this.renderer = renderer;
        this.i18n = i18n;
        this.awsConnectorService2 = awsConnectorService2;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ArrayList<AUIMessage> messages = new ArrayList<AUIMessage>();
        List<Object> availableConnectors = new ArrayList();
        try {
            AWSConsoleLoginConnectorFilter loginConnectorFilter = new AWSConsoleLoginConnectorFilter(this.awsConnectorService2);
            availableConnectors = loginConnectorFilter.getAvailableSSOConnectors();
        }
        catch (LicenseException le) {
            messages.add(this.licenseHelper.createAUIErrorMessage(le, AUIMessage.Type.WARNING));
        }
        if (availableConnectors.isEmpty()) {
            AUIMessage message = new AUIMessage(AUIMessage.Type.HINT).setTitle(this.i18n.getText("ifaws.awsConsoleLinkSelection.noLinksAvailableHint"));
            messages.add(message);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("messages", messages);
        context.put("availableConnectors", availableConnectors);
        context.put("pathToProxyServlet", request.getContextPath() + "/plugins/servlet/identity-federation-for-aws/aws-console-login/");
        context.put("pathToOverviewServlet", request.getContextPath() + AWS_CONNECTOR_OVERVIEW_SERVLET_PATH);
        context.put("pluginKey", PluginInfo.PLUGIN_KEY);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("net/utoolity/atlassian/ifaws/templates/awsConsoleLinkSelection.vm", context, (Writer)response.getWriter());
    }
}

