/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ao;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.utoolity.atlassian.ifaws.ao.AWSAccount;
import org.apache.commons.lang.StringUtils;

public final class AWSAccountPredicates {
    private AWSAccountPredicates() {
    }

    public static Predicate<AWSAccount> nameEquals(final String searchTerm) {
        return new Predicate<AWSAccount>(){

            public boolean apply(@Nullable AWSAccount input) {
                return StringUtils.equals((String)input.getName(), (String)searchTerm);
            }
        };
    }

    public static Predicate<AWSAccount> nameEqualsIgnoreCase(final String searchTerm) {
        return new Predicate<AWSAccount>(){

            public boolean apply(@Nullable AWSAccount input) {
                return StringUtils.equalsIgnoreCase((String)input.getName(), (String)searchTerm);
            }
        };
    }

    public static Predicate<AWSAccount> nameContainsIgnoreCase(final String searchTerm) {
        return new Predicate<AWSAccount>(){

            public boolean apply(@Nullable AWSAccount input) {
                return StringUtils.containsIgnoreCase((String)input.getName(), (String)searchTerm);
            }
        };
    }
}

