/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.dry;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.upm.api.license.HostLicenseInformation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.utoolity.atlassian.dry.ApplicationVersionComparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginInfo {
    private static final String IFAWS_1037_WORKAROUND_VERSION_CUTOFF = "5.9.2";
    private static final String IFAWS_1037_WORKAROUND_MESSAGE = "IFAWS-1037 workaround: Value not available in Bitbucket to prevent NoClassDefFound error";
    public static final String PLUGIN_GROUP_ID;
    public static final String PLUGIN_ARTIFACT_ID;
    public static final String UTOOLITY_PROJECT_KEY;
    public static final String PLUGIN_KEY;
    public static final String PLUGIN_SERVLET_PATH = "/plugins/servlet/identity-federation-for-aws";
    public static final String PLUGIN_CONFIGURATION_PATH = "/plugins/servlet/identity-federation-for-aws/configuration";
    public static final String PLUGIN_CONNECTOR_OVERVIEW_PATH = "/plugins/servlet/identity-federation-for-aws/configuration/aws-connector";
    public static final String PLUGIN_SETTINGS_NAMESPACE;
    public static final String PLUGIN_RESOURCE_BASE_URL;
    private final ApplicationProperties applicationProperties;
    private final Plugin plugin;
    private final HostLicenseInformation hostLicenseInformation;

    @Autowired
    public PluginInfo(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport HostLicenseInformation hostLicenseInformation, @ComponentImport LicenseHandler licenseHandler) {
        this.applicationProperties = applicationProperties;
        this.plugin = pluginAccessor.getPlugin(PLUGIN_KEY);
        this.hostLicenseInformation = hostLicenseInformation;
    }

    public String getApplicationName() {
        return this.applicationProperties.getDisplayName();
    }

    public String getApplicationVersion() {
        return this.applicationProperties.getVersion();
    }

    public String getPluginName() {
        return this.plugin.getName();
    }

    public String getPluginVersion() {
        return this.plugin.getPluginInformation().getVersion();
    }

    public String getHostIsDataCenter() {
        if (this.applyIFAWS1037Workaround()) {
            return IFAWS_1037_WORKAROUND_MESSAGE;
        }
        return String.valueOf(this.hostLicenseInformation.isDataCenter());
    }

    public String getHostIsEvaluation() {
        if (this.applyIFAWS1037Workaround()) {
            return IFAWS_1037_WORKAROUND_MESSAGE;
        }
        return String.valueOf(this.hostLicenseInformation.isEvaluation());
    }

    public String getHostSen() {
        if (this.applyIFAWS1037Workaround()) {
            return IFAWS_1037_WORKAROUND_MESSAGE;
        }
        return (String)this.hostLicenseInformation.hostSen().map(i -> i.toString()).getOrElse((Object)"unknown");
    }

    public String getHostEdition() {
        if (this.applyIFAWS1037Workaround()) {
            return IFAWS_1037_WORKAROUND_MESSAGE;
        }
        return (String)this.hostLicenseInformation.getEdition().map(i -> i.toString()).getOrElse((Object)"unlimited");
    }

    private boolean applyIFAWS1037Workaround() {
        if ("Bitbucket".equals(this.getApplicationName())) {
            return new ApplicationVersionComparator(this.applicationProperties).isLowerThan(IFAWS_1037_WORKAROUND_VERSION_CUTOFF);
        }
        return false;
    }

    static {
        Properties properties = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream("identity-federation-for-aws.properties");
        try {
            properties.load(stream);
            PLUGIN_GROUP_ID = properties.getProperty("plugin.groupId");
            PLUGIN_ARTIFACT_ID = properties.getProperty("plugin.artifactId");
            UTOOLITY_PROJECT_KEY = properties.getProperty("utoolity.project.key");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read 'identity-federation-for-aws.properties'!");
        }
        PLUGIN_KEY = PLUGIN_GROUP_ID + "." + PLUGIN_ARTIFACT_ID;
        PLUGIN_SETTINGS_NAMESPACE = "net.utoolity." + UTOOLITY_PROJECT_KEY.toLowerCase();
        PLUGIN_RESOURCE_BASE_URL = "/download/resources/" + PLUGIN_KEY + ":";
    }
}

