/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.dry;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.text.MessageFormat;
import java.util.Set;
import net.utoolity.atlassian.dry.AUIMessage;
import net.utoolity.atlassian.dry.PluginDetector;
import net.utoolity.atlassian.dry.PluginInfo;
import net.utoolity.atlassian.dry.WhitelistedPlugin;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseHelper {
    private static final Logger log = LoggerFactory.getLogger(LicenseHelper.class);
    private static final String UPM_PLUGIN_LINK_PATH = "/plugins/servlet/upm#manage/" + PluginInfo.PLUGIN_KEY;
    private final PluginLicenseManager licenseManager;
    private final PluginInfo pluginInfo;
    private final ApplicationProperties applicationProperties;
    private final I18nResolver i18n;
    private final PluginDetector pluginDetector;

    @Autowired
    public LicenseHelper(@ComponentImport PluginLicenseManager licenseManager, PluginInfo pluginInfo, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport I18nResolver i18n, PluginDetector pluginDetector) {
        this.licenseManager = licenseManager;
        this.pluginInfo = pluginInfo;
        this.applicationProperties = applicationProperties;
        this.i18n = i18n;
        this.pluginDetector = pluginDetector;
    }

    public void ensureValidLicense() throws LicenseException {
        this.ensureValidLicense(true);
    }

    public void ensureValidLicense(boolean usePluginWhitelist) throws LicenseException {
        Set<WhitelistedPlugin> pluginWhitelist;
        if (usePluginWhitelist && this.hasIndirectLicense(pluginWhitelist = PluginConfiguration.getLicenseCheckPluginWhitelist())) {
            return;
        }
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            if (pluginLicense.getError().isDefined()) {
                LicenseError originalError = (LicenseError)pluginLicense.getError().get();
                throw new LicenseException(originalError);
            }
            return;
        }
        throw new LicenseException(LicenseException.LicenseErrorExtended.MISSING);
    }

    private boolean hasIndirectLicense(Set<WhitelistedPlugin> pluginWhitelist) {
        return this.isWhitelistedPluginEnabled(pluginWhitelist);
    }

    private boolean isWhitelistedPluginEnabled(Set<WhitelistedPlugin> pluginWhitelist) {
        boolean result = false;
        if (null != pluginWhitelist && !pluginWhitelist.isEmpty()) {
            for (WhitelistedPlugin whitelistedPlugin : pluginWhitelist) {
                if (!this.pluginDetector.isPluginEnabled(whitelistedPlugin.getPluginKey())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public String getErrorMessageText(LicenseException licenseException) {
        String key = "ifaws.licenseHelper.errorMessage." + licenseException.getMessage();
        String rawMessage = this.i18n.getText(key);
        String addOnName = this.pluginInfo.getPluginName();
        String atlassianApplication = this.applicationProperties.getDisplayName();
        String licenseType = "LICENSE_TYPE";
        String limitValue = "LIMIT_VALUE";
        String limit = "LIMIT";
        String version = this.pluginInfo.getPluginVersion();
        String message = MessageFormat.format(rawMessage, addOnName, atlassianApplication, licenseType, limitValue, limit, version);
        return message;
    }

    public AUIMessage createAUIErrorMessage(LicenseException le, AUIMessage.Type messageType) {
        return this.createAUIErrorMessage(le, messageType, false);
    }

    public AUIMessage createAUIErrorMessage(LicenseException le, AUIMessage.Type messageType, boolean withReadonlyHint) {
        AUIMessage message = new AUIMessage(messageType).setTitle(this.i18n.getText("ifaws.licenseHelper.errorMessage.title")).setMessage(this.getErrorMessageText(le));
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
        String pluginManagementURI = baseUrl + UPM_PLUGIN_LINK_PATH;
        String pluginManagementLinkText = this.i18n.getText("ifaws.licenseHelper.errorMessage.managementLinkText");
        String pluginManagementLink = "<a href=\"" + pluginManagementURI + "\" >" + pluginManagementLinkText + "</a>";
        message.addMessageParagraphHtml(pluginManagementLink);
        if (withReadonlyHint) {
            message.addMessageParagraph(this.i18n.getText("ifaws.licenseHelper.errorMessage.readOnlyHint"));
        }
        return message;
    }
}

