/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.dry;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class AUIMessage {
    private final Type type;
    private String messageClass;
    private String iconClass;
    private String title = "";
    private final List<MessageParagraph> message = new ArrayList<MessageParagraph>();

    public AUIMessage() {
        this(Type.GENERIC);
    }

    public AUIMessage(Type type) {
        this.type = type;
    }

    public AUIMessage(Type type, String title) {
        this(type);
        this.title = title;
    }

    public AUIMessage(Type type, String title, String message) {
        this(type, title);
        this.message.add(new MessageParagraph(message, false));
    }

    public Type getType() {
        return this.type;
    }

    public String getMessageClass() {
        if (null != this.messageClass) {
            return this.messageClass;
        }
        return this.type.getMessageClass();
    }

    private String createFullAUIMessageClass() {
        String basicClass = this.getMessageClass();
        if (StringUtils.isBlank((String)basicClass)) {
            return "";
        }
        return "aui-message-" + basicClass;
    }

    public AUIMessage setMessageClass(String messageClass) {
        this.messageClass = messageClass;
        return this;
    }

    public String getIconClass() {
        if (null != this.iconClass) {
            return this.iconClass;
        }
        return this.type.getIconClass();
    }

    public AUIMessage setIconClass(String iconClass) {
        this.iconClass = iconClass;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public AUIMessage setTitle(String title) {
        this.title = title;
        return this;
    }

    public List<MessageParagraph> getMessage() {
        return this.message;
    }

    public AUIMessage setMessage(String message) {
        this.message.clear();
        return this.addMessageParagraph(message);
    }

    public AUIMessage addMessageParagraph(String messageParagraph) {
        this.message.add(new MessageParagraph(messageParagraph, false));
        return this;
    }

    public AUIMessage addMessageParagraphHtml(String messageParagraphHtml) {
        this.message.add(new MessageParagraph(messageParagraphHtml, true));
        return this;
    }

    public String asHtml() {
        StringBuilder html = new StringBuilder();
        String messageClasses = "aui-message " + this.createFullAUIMessageClass();
        html.append("<div class=\"" + messageClasses.trim() + "\">\n");
        html.append("  <p class=\"title\">\n");
        if (!this.getTitle().isEmpty()) {
            html.append("    <strong>" + StringEscapeUtils.escapeHtml((String)this.getTitle()) + "</strong>\n");
        }
        html.append("  </p>\n");
        for (MessageParagraph messageParagraph : this.getMessage()) {
            String paragraph = messageParagraph.isHtml ? messageParagraph.paragraph : StringEscapeUtils.escapeHtml((String)messageParagraph.paragraph);
            html.append("  <p>" + paragraph + "</p>\n");
        }
        html.append("</div>\n");
        return html.toString();
    }

    private class MessageParagraph {
        public String paragraph;
        public boolean isHtml;

        public MessageParagraph(String paragraph, boolean isHtml) {
            this.paragraph = paragraph;
            this.isHtml = isHtml;
        }
    }

    public static enum Type {
        GENERIC("", "icon-generic"),
        HINT("hint", "icon-hint"),
        SUCCESS("success", "icon-success"),
        WARNING("warning", "icon-warning"),
        ERROR("error", "icon-error");

        private String messageClass;
        private String iconClass;

        private Type(String messageClass, String iconClass) {
            this.messageClass = messageClass;
            this.iconClass = iconClass;
        }

        public String getMessageClass() {
            return this.messageClass;
        }

        public String getIconClass() {
            return this.iconClass;
        }
    }
}

