/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws;

import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.utoolity.atlassian.dry.ApplicationVersionComparator;
import net.utoolity.atlassian.dry.PluginInfo;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public final class CustomPluginEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(CustomPluginEventListener.class);
    private final PluginEventManager pluginEventManager;
    private final ApplicationProperties applicationProperties;

    public CustomPluginEventListener(PluginEventManager pluginEventManager, ApplicationProperties applicationProperties) {
        this.pluginEventManager = pluginEventManager;
        this.applicationProperties = applicationProperties;
    }

    private TaskManager tryGetTaskManager() {
        TaskManager taskManager = (TaskManager)ComponentLocator.getComponent(TaskManager.class);
        return taskManager;
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        log.debug("Plugin enabled event ...");
        if (event == null) {
            return;
        }
        Plugin plugin = event.getPlugin();
        if (plugin == null) {
            return;
        }
        log.debug("... for plugin: {}", (Object)plugin.getKey());
        if (PluginInfo.PLUGIN_KEY.equals(plugin.getKey())) {
            this.ownPluginEnabled(plugin);
        }
    }

    private void ownPluginEnabled(Plugin plugin) {
        ApplicationVersionComparator applicationVersionComparator = new ApplicationVersionComparator(this.applicationProperties);
        String comparisonVersionString = "5.6.0";
        if (applicationVersionComparator.isLowerOrEqualTo(comparisonVersionString)) {
            log.info("Detected application version lower or equal to {} ...", (Object)comparisonVersionString);
            log.info("... reinitializing own task module descriptors to prevent ServiceProxyDestroyedException, see https://jira.atlassian.com/browse/BAM-14801 for details.");
            this.reinitializeOwnTaskModuleDescriptors(plugin);
        } else {
            log.info("Detected application version higher than {}, skipping reinitializing of own task module descriptors.", (Object)comparisonVersionString);
        }
    }

    private void reinitializeOwnTaskModuleDescriptors(Plugin plugin) {
        TaskManager taskManager = this.tryGetTaskManager();
        if (null == taskManager) {
            log.warn("Failed to retrieve taskManager!");
            return;
        }
        Map<String, Element> taskTypeElements = this.getOwnTaskTypeElements(plugin);
        if (taskTypeElements.isEmpty()) {
            log.warn("Failed to retrieve own task type elements!");
            return;
        }
        for (Map.Entry<String, Element> entry : taskTypeElements.entrySet()) {
            String combinedKey = PluginInfo.PLUGIN_KEY + ":" + entry.getKey();
            log.debug("Retrieving single task descriptor by combined key {} ...", (Object)combinedKey);
            TaskModuleDescriptor singleTaskModuleDescriptor = taskManager.getTaskDescriptor(combinedKey);
            log.debug("... got single task descriptor with module key {}", (Object)singleTaskModuleDescriptor.getKey());
            if (null == singleTaskModuleDescriptor) continue;
            log.debug("... reinitializing task descriptor with module key {}", (Object)singleTaskModuleDescriptor.getKey());
            try {
                singleTaskModuleDescriptor.init(plugin, entry.getValue());
            }
            catch (PluginParseException e) {
                log.warn("PluginParseException while trying to reinitialize task descriptor {}, stackTrace: {}", (Object)e.getMessage(), (Object)e.getStackTrace());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Element> getOwnTaskTypeElements(Plugin plugin) {
        HashMap<String, Element> taskTypeElements = new HashMap<String, Element>();
        InputStream pluginDescriptorXMLStream = this.getClass().getClassLoader().getResourceAsStream("atlassian-plugin.xml");
        if (null != pluginDescriptorXMLStream) {
            try {
                String pluginDescriptorXML = IOUtils.toString((InputStream)pluginDescriptorXMLStream, (String)"UTF-8");
                Document document = DocumentHelper.parseText((String)pluginDescriptorXML);
                Element root = document.getRootElement();
                String pluginKey = root.attributeValue("key");
                if (null == pluginKey || !plugin.getKey().equals(pluginKey)) return taskTypeElements;
                Iterator i = root.elementIterator("taskType");
                while (i.hasNext()) {
                    Element taskTypeElement = (Element)i.next();
                    String taskKey = taskTypeElement.attributeValue("key");
                    log.debug("Found taskType with key {}", (Object)taskKey);
                    if (null == taskKey) continue;
                    taskTypeElements.put(taskKey, taskTypeElement);
                }
                return taskTypeElements;
            }
            catch (IOException e) {
                log.warn("IOException while trying to read plugin descriptor {}, stackTrace: {}", (Object)e.getMessage(), (Object)e.getStackTrace());
                return taskTypeElements;
            }
            catch (DocumentException e) {
                log.warn("DocumentException while trying to parse plugin descriptor {}, stackTrace: {}", (Object)e.getMessage(), (Object)e.getStackTrace());
                return taskTypeElements;
            }
        } else {
            log.warn("Failed to retrieve plugin descriptor xml (atlassian-plugin.xml)!");
        }
        return taskTypeElements;
    }

    public void afterPropertiesSet() throws Exception {
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() throws Exception {
        this.pluginEventManager.unregister((Object)this);
    }
}

