/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import java.util.Map;
import net.utoolity.atlassian.bamboo.ifaws.BaseTask;
import net.utoolity.atlassian.dry.AmazonWebServiceClientFactory;
import net.utoolity.atlassian.ifaws.AWSSecurityTokenClientProxy;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.api.STSCallerIdentityDTO;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsVariablesTask
extends BaseTask {
    private static final String VARIABLE_NAME_AWS_CREDENTIALS_JSON_PASSWORD = "credentials.json.password";
    private static final String VARIABLE_NAME_AWS_SESSION_TOKEN = "sessionToken";
    private static final String VARIABLE_NAME_AWS_SESSION_TOKEN_PASSWORD = "sessionToken.password";
    private static final String VARIABLE_NAME_AWS_SECRET_ACCESS_KEY = "secretAccessKey";
    private static final String VARIABLE_NAME_AWS_SECRET_ACCESS_KEY_PASSWORD = "secretAccessKey.password";
    private static final String VARIABLE_NAME_AWS_ACCESS_KEY_ID = "accessKeyId";
    public static final String CALLER_IDENTITY_NAMESPACE = ".callerIdentity";
    private static final String VARIABLE_NAME_CALLER_IDENTITY_ACCOUNT = ".callerIdentity.account";
    private static final String VARIABLE_NAME_CALLER_IDENTITY_ARN = ".callerIdentity.arn";
    private static final String VARIABLE_NAME_CALLER_IDENTITY_USER_ID = ".callerIdentity.userId";
    private static final String VARIABLE_NAME_CALLER_IDENTITY_JSON = ".callerIdentity.json";
    private static final String CONNECTOR_NAMESPACE = ".connector";
    private static final String VARIABLE_NAME_CONNECTOR_ID = ".connector.id";
    private static final String VARIABLE_NAME_CONNECTOR_NAME = ".connector.name";
    private static final String VARIABLE_NAME_CONNECTOR_JSON = ".connector.json";
    private static final Logger log = LoggerFactory.getLogger(CredentialsVariablesTask.class);

    public CredentialsVariablesTask(CustomVariableContext customVariableContext, I18nBeanFactory i18nBeanFactory) {
        super(customVariableContext, i18nBeanFactory);
    }

    @Override
    protected TaskResult execute(TaskResultBuilder taskResultBuilder, ConfigurationMap configurationMap, BuildLogger buildLogger, CommonTaskContext commonTaskContext, AWSCredentialsProvider awsCredentialsProvider, DefaultCloudProvider cloudProvider, ClientConfiguration clientConfiguration) throws TaskException {
        AWSCredentials awsCredentials = awsCredentialsProvider.getCredentials();
        this.createCredentialVariables(commonTaskContext, awsCredentials);
        boolean addCallerIdentityVariables = configurationMap.getAsBoolean("addCallerIdentityVariables");
        if (addCallerIdentityVariables) {
            this.createCallerIdentityVariables(commonTaskContext, awsCredentials, cloudProvider);
        }
        this.createConnectorVariables(commonTaskContext);
        return taskResultBuilder.build();
    }

    private void createCredentialVariables(CommonTaskContext commonTaskContext, AWSCredentials awsCredentials) {
        BuildLogger buildLogger = commonTaskContext.getBuildLogger();
        buildLogger.addBuildLogEntry("Creating variables for retrieved AWS credentials:");
        LinkedHashMap<String, String> jsonRepresentationBase = new LinkedHashMap<String, String>();
        String accessKeyIdKey = VARIABLE_NAME_AWS_ACCESS_KEY_ID;
        String accessKeyId = awsCredentials.getAWSAccessKeyId();
        jsonRepresentationBase.put(VARIABLE_NAME_AWS_ACCESS_KEY_ID, accessKeyId);
        this.createAndLogVariable(buildLogger, accessKeyIdKey, accessKeyId);
        String secretKeyKey = VARIABLE_NAME_AWS_SECRET_ACCESS_KEY_PASSWORD;
        String secretKey = awsCredentials.getAWSSecretKey();
        jsonRepresentationBase.put(VARIABLE_NAME_AWS_SECRET_ACCESS_KEY, secretKey);
        this.createAndLogVariable(buildLogger, secretKeyKey, secretKey);
        if (awsCredentials instanceof AWSSessionCredentials) {
            String sessionTokenKey = VARIABLE_NAME_AWS_SESSION_TOKEN_PASSWORD;
            String sessionToken = ((AWSSessionCredentials)awsCredentials).getSessionToken();
            jsonRepresentationBase.put(VARIABLE_NAME_AWS_SESSION_TOKEN, sessionToken);
            this.createAndLogVariable(buildLogger, sessionTokenKey, sessionToken);
        }
        String credentialsJsonKey = VARIABLE_NAME_AWS_CREDENTIALS_JSON_PASSWORD;
        String credentialsJson = new Gson().toJson(jsonRepresentationBase);
        this.createAndLogVariable(buildLogger, credentialsJsonKey, credentialsJson);
    }

    private void createCallerIdentityVariables(CommonTaskContext commonTaskContext, AWSCredentials awsCredentials, DefaultCloudProvider cloudProvider) {
        BuildLogger buildLogger = commonTaskContext.getBuildLogger();
        buildLogger.addBuildLogEntry("Creating caller identity variables for retrieved AWS credentials:");
        AmazonWebServiceClientFactory clientFactory = new AmazonWebServiceClientFactory();
        AWSSecurityTokenClientProxy awsSecurityTokenClientProxy = new AWSSecurityTokenClientProxy(clientFactory);
        STSCallerIdentityDTO stsCallerIdentityDTO = awsSecurityTokenClientProxy.getCallerIdentity(awsCredentials, cloudProvider);
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_CALLER_IDENTITY_ACCOUNT, stsCallerIdentityDTO.getAccount());
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_CALLER_IDENTITY_ARN, stsCallerIdentityDTO.getArn());
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_CALLER_IDENTITY_USER_ID, stsCallerIdentityDTO.getUserId());
        String callerIdentityJson = new Gson().toJson((Object)stsCallerIdentityDTO);
        this.createAndLogVariable(buildLogger, VARIABLE_NAME_CALLER_IDENTITY_JSON, callerIdentityJson);
    }

    private void createConnectorVariables(CommonTaskContext commonTaskContext) {
        String connectorId;
        Map runtimeTaskContext = commonTaskContext.getRuntimeTaskContext();
        boolean isConnectorServiceAvailable = Boolean.parseBoolean((String)runtimeTaskContext.get("isConnectorServiceAvailable"));
        if (isConnectorServiceAvailable && StringUtils.isNotBlank((String)(connectorId = (String)runtimeTaskContext.get("connectorId")))) {
            BuildLogger buildLogger = commonTaskContext.getBuildLogger();
            buildLogger.addBuildLogEntry("Creating variables for underlying AWS connector:");
            this.createAndLogVariable(buildLogger, VARIABLE_NAME_CONNECTOR_ID, connectorId);
            String connectorName = (String)runtimeTaskContext.get("connectorName");
            this.createAndLogVariable(buildLogger, VARIABLE_NAME_CONNECTOR_NAME, connectorName);
            LinkedHashMap<String, String> jsonRepresentationBase = new LinkedHashMap<String, String>();
            jsonRepresentationBase.put(StringUtils.substringAfterLast((String)VARIABLE_NAME_CONNECTOR_ID, (String)"."), connectorId);
            jsonRepresentationBase.put(StringUtils.substringAfterLast((String)VARIABLE_NAME_CONNECTOR_NAME, (String)"."), connectorName);
            String connectorJson = new Gson().toJson(jsonRepresentationBase);
            this.createAndLogVariable(buildLogger, VARIABLE_NAME_CONNECTOR_JSON, connectorJson);
        }
    }
}

