/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.utoolity.atlassian.bamboo.ifaws.VariableScope;
import net.utoolity.atlassian.dry.AUIMessage;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.dry.PluginInfo;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO2;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskConfigurator
extends AbstractTaskConfigurator {
    private static final Logger log = LoggerFactory.getLogger(BaseTaskConfigurator.class);
    private PluginInfo pluginInfo;
    private LicenseHelper licenseHelper;
    private AWSConnectorService2 awsConnectorService2;
    private ApplicationProperties applicationProperties;
    public static final String PLUGIN_VERSION_ON_SAVE = "pluginVersionOnSave";
    public static final String PLUGIN_CONFIG_VERSION_ON_SAVE = "pluginConfigVersionOnSave";
    public static final String CURRENT_PLUGIN_CONFIG_VERSION = "1";
    public static final String AWS_CONNECTOR_ID = "awsConnectorId";
    public static final String AWS_CONNECTOR_ID_VARIABLE = "awsConnectorIdVariable";
    public static final String AWS_CREDENTIALS_SOURCE = "awsCredentialsSource";
    public static final String AWS_CREDENTIALS_SOURCE_IFAWS_CONNECTOR = "IFAWS_CONNECTOR";
    public static final String AWS_CREDENTIALS_SOURCE_IAM_ROLE_AGENTS = "IAM_ROLE_AGENTS";
    public static final String AWS_IAM_ROLE_AGENTS_ROLE_ARN = "awsIamRoleAgentsArn";
    public static final String AWS_CONNECTOR_VARIABLE_KEY = "AWS_CONNECTOR_VARIABLE_KEY";
    public static final String AWS_CREDENTIALS_SOURCE_DEFAULT = "IFAWS_CONNECTOR";
    public static final String AWS_CREDENTIALS_SOURCE_OPTIONS = "awsCredentialsSourceOptions";
    public static final String IS_CREDENTIALS_SECTION_COLLAPSED_KEY = "IS_CREDENTIALS_SECTION_COLLAPSED";
    public static final String IS_VARIABLES_SECTION_COLLAPSED_KEY = "IS_VARIABLES_SECTION_COLLAPSED";
    public static final String RESOURCE_REGIONS = "resourceRegions";
    public static final String RESOURCE_REGION = "resourceRegion";
    public static final String RESOURCE_REGION_VARIABLE_KEY = "resourceRegionVariable";
    public static final String RESOURCE_REGION_VARIABLE_PLACEHOLDER = "useResourceRegionVariable";
    public static final String DEFAULT_REGION = "us-east-1";
    public static final String VARIABLE_SCOPE = "variableScope";
    public static final VariableScope VARIABLE_SCOPE_DEFAULT = VariableScope.LOCAL;
    public static final String VARIABLE_SCOPE_OPTIONS_KEY = "variableScopeOptions";
    private static final ImmutableList<String> VARIABLE_SCOPE_OPTIONS = ImmutableList.of((Object)VariableScope.LOCAL.name(), (Object)VariableScope.RESULT.name());
    public static final String VARIABLE_NAMESPACE = "variableNamespace";
    public static final String VARIABLE_NAMESPACE_DEFAULT = "custom.aws";
    private static final Set<String> BASE_FIELD_COLLECTION = ImmutableSet.builder().add((Object[])new String[]{"awsConnectorId", "awsConnectorIdVariable", "awsCredentialsSource", "awsIamRoleAgentsArn", "resourceRegion", "resourceRegionVariable", "variableScope", "variableNamespace"}).build();
    private static final String AWS_CONNECTOR_OPTIONS = "awsConnectorOptions";
    private static final String IFAWS_CONNECTOR_CONFIG_PATH = "/plugins/servlet/identity-federation-for-aws/configuration/aws-connector";
    private static final String IFAWS_STATIC_RESOURCE_PATH = "/download/resources/net.utoolity.atlassian.bamboo.identity-federation-for-aws-bamboo/ifaws-resources";
    private static String VARIABLE_PATTERN = "\\$\\{\\S+?}";
    private static final String VARIABLE_KEY_PATTERN = "[a-zA-Z0-9_\\.]+";

    public void setPluginInfo(PluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
    }

    public void setLicenseHelper(LicenseHelper licenseHelper) {
        this.licenseHelper = licenseHelper;
    }

    public void setAWSConnectorService2(AWSConnectorService2 awsConnectorService2) {
        this.awsConnectorService2 = awsConnectorService2;
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    abstract Set<String> getFieldCollection();

    private Iterable<String> getCombinedFieldCollection() {
        return Iterables.concat(BASE_FIELD_COLLECTION, this.getFieldCollection());
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(RESOURCE_REGION, DEFAULT_REGION);
        context.put(AWS_CREDENTIALS_SOURCE, "IFAWS_CONNECTOR");
        context.put(IS_CREDENTIALS_SECTION_COLLAPSED_KEY, false);
        context.put(IS_VARIABLES_SECTION_COLLAPSED_KEY, true);
        context.put(VARIABLE_SCOPE, VARIABLE_SCOPE_DEFAULT.name());
        context.put(VARIABLE_NAMESPACE, VARIABLE_NAMESPACE_DEFAULT);
        this.populateContextForEditAndCreate(context);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, this.getCombinedFieldCollection());
        if (!context.containsKey(RESOURCE_REGION) || null == context.get(RESOURCE_REGION)) {
            context.put(RESOURCE_REGION, DEFAULT_REGION);
        }
        context.put(IS_CREDENTIALS_SECTION_COLLAPSED_KEY, true);
        context.put(IS_VARIABLES_SECTION_COLLAPSED_KEY, this.isVariablesSectionCollapsed(context));
        if (!context.containsKey(VARIABLE_SCOPE) || null == context.get(VARIABLE_SCOPE)) {
            context.put(VARIABLE_SCOPE, VARIABLE_SCOPE_DEFAULT.name());
        }
        if (!context.containsKey(VARIABLE_NAMESPACE) || null == context.get(VARIABLE_NAMESPACE)) {
            context.put(VARIABLE_NAMESPACE, VARIABLE_NAMESPACE_DEFAULT);
        }
        this.populateContextForEditAndCreate(context);
    }

    private boolean isVariablesSectionCollapsed(Map<String, Object> context) {
        boolean isNonDefaultScope = context.containsKey(VARIABLE_SCOPE) && (String)context.get(VARIABLE_SCOPE) != VARIABLE_SCOPE_DEFAULT.name();
        boolean isNonDefaultNamespace = context.containsKey(VARIABLE_NAMESPACE) && (String)context.get(VARIABLE_NAMESPACE) != VARIABLE_NAMESPACE_DEFAULT;
        return !isNonDefaultScope && !isNonDefaultNamespace;
    }

    protected void populateContextForEditAndCreate(Map<String, Object> context) {
        context.put("messages", this.createMessages().toString());
        context.put(RESOURCE_REGIONS, this.getRegionMapWithVariablePlaceholder());
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
        String connectorConfigUrl = baseUrl + IFAWS_CONNECTOR_CONFIG_PATH;
        String pseudoDescription = MessageFormat.format(this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsCredentialsSourceDescriptionKludge"), connectorConfigUrl);
        context.put("awsCredentialsSourceDescriptionKludge", pseudoDescription);
        context.put("showIfawsNotConfiguredMessage", !this.hasIfawsConnectors());
        if (!this.hasIfawsConnectors()) {
            String messageParagraph = MessageFormat.format(this.getI18nBean().getText("You need to <a href=\"{0}\" target=\"_blank\" >configure at least one AWS Connector</a> first."), connectorConfigUrl);
            context.put("ifawsNotConfiguredMessageWarn", new AUIMessage(AUIMessage.Type.WARNING).addMessageParagraphHtml(messageParagraph).asHtml());
        }
        String pathToStaticResources = baseUrl + IFAWS_STATIC_RESOURCE_PATH;
        context.put("pathToStaticResources", pathToStaticResources);
        context.put(AWS_CONNECTOR_OPTIONS, this.getAWSConnectorMap());
        context.put(AWS_CREDENTIALS_SOURCE_OPTIONS, this.getCredentialsSourcesMap());
        context.put(VARIABLE_SCOPE_OPTIONS_KEY, VARIABLE_SCOPE_OPTIONS);
        context.put("issueCollectorTriggerText", this.getI18nBean().getText("ifaws.issueCollector.trigger.text"));
        context.put("issueCollectorTriggerTitle", this.getI18nBean().getText("ifaws.issueCollector.trigger.title"));
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        String awsCredentialsSource = params.getString(AWS_CREDENTIALS_SOURCE, "IFAWS_CONNECTOR");
        if (awsCredentialsSource.equals("IFAWS_CONNECTOR")) {
            this.validateAWSConnectorId(params, errorCollection);
        } else if (awsCredentialsSource.equals(AWS_CREDENTIALS_SOURCE_IAM_ROLE_AGENTS)) {
            this.validateIamRoleAgentsRoleArn(params, errorCollection);
        } else {
            errorCollection.addError(AWS_CREDENTIALS_SOURCE, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsCredentialsSource.error"));
        }
        this.validateVariableScope(params, errorCollection);
        this.validateVariableNamespace(params, errorCollection);
    }

    private void validateAWSConnectorId(ActionParametersMap params, ErrorCollection errorCollection) {
        String awsConnectorId = params.getString(AWS_CONNECTOR_ID, "-1");
        if (awsConnectorId.equals("-1")) {
            errorCollection.addError(AWS_CONNECTOR_ID, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsConnector.errorMissing"));
            return;
        }
        if (awsConnectorId.equals(AWS_CONNECTOR_VARIABLE_KEY)) {
            this.validateAWSCredentialsSourceIfawsVariable(params, errorCollection);
            return;
        }
        AWSConnectorDTO2 selectedConnector = this.awsConnectorService2.getConnector(awsConnectorId);
        if (null == selectedConnector) {
            errorCollection.addError(AWS_CONNECTOR_ID, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsConnector.errorUnknown"));
        }
    }

    private void validateAWSCredentialsSourceIfawsVariable(ActionParametersMap params, ErrorCollection errorCollection) {
        String awsConnectorIdVariable = params.getString(AWS_CONNECTOR_ID_VARIABLE);
        if (StringUtils.isBlank((String)awsConnectorIdVariable) || !BaseTaskConfigurator.isVariable(awsConnectorIdVariable)) {
            errorCollection.addError(AWS_CONNECTOR_ID_VARIABLE, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsConnectorVariable.error"));
        }
    }

    private void validateIamRoleAgentsRoleArn(ActionParametersMap params, ErrorCollection errorCollection) {
        String iamRoleAgentsRoleArn = params.getString(AWS_IAM_ROLE_AGENTS_ROLE_ARN);
        if (StringUtils.isBlank((String)iamRoleAgentsRoleArn)) {
            return;
        }
        if (!BaseTaskConfigurator.isVariable(iamRoleAgentsRoleArn) && !this.isValidRoleArn(iamRoleAgentsRoleArn)) {
            errorCollection.addError(AWS_IAM_ROLE_AGENTS_ROLE_ARN, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsIamRoleAgentsRoleArn.error"));
        }
    }

    private boolean isValidRoleArn(String iamRoleAgentsRoleArn) {
        return StringUtils.isNotBlank((String)iamRoleAgentsRoleArn) && iamRoleAgentsRoleArn.startsWith("arn:");
    }

    protected abstract Map<String, String> getRegionMap();

    private Map<String, String> getRegionMapWithVariablePlaceholder() {
        LinkedHashMap<String, String> regionMap = new LinkedHashMap<String, String>();
        regionMap.putAll(this.getRegionMap());
        regionMap.put(RESOURCE_REGION_VARIABLE_PLACEHOLDER, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.resourceRegion.variablePlaceholder.value"));
        return regionMap;
    }

    public static String extractRegionFromConfigurationMap(ConfigurationMap configurationMap) {
        String region = (String)configurationMap.get((Object)RESOURCE_REGION);
        if (null != region && region.equals(RESOURCE_REGION_VARIABLE_PLACEHOLDER)) {
            region = (String)configurationMap.get((Object)RESOURCE_REGION_VARIABLE_KEY);
        }
        return region;
    }

    protected void validateRegion(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String regionVariable;
        String region = params.getString(RESOURCE_REGION);
        if (region.equals(RESOURCE_REGION_VARIABLE_PLACEHOLDER) && !BaseTaskConfigurator.isVariable(regionVariable = params.getString(RESOURCE_REGION_VARIABLE_KEY))) {
            errorCollection.addError(RESOURCE_REGION_VARIABLE_KEY, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.resourceRegionVariable.error"));
        }
    }

    public static boolean isVariable(String candidate) {
        String pattern = "^" + VARIABLE_PATTERN + "$";
        return candidate.matches(pattern);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        String region;
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, this.getCombinedFieldCollection());
        config.put(PLUGIN_VERSION_ON_SAVE, this.pluginInfo.getPluginVersion());
        config.put(PLUGIN_CONFIG_VERSION_ON_SAVE, CURRENT_PLUGIN_CONFIG_VERSION);
        String awsCredentialsSource = (String)config.get(AWS_CREDENTIALS_SOURCE);
        if (AWS_CREDENTIALS_SOURCE_IAM_ROLE_AGENTS.equals(awsCredentialsSource)) {
            config.put(AWS_CONNECTOR_ID, "-1");
        }
        if (!RESOURCE_REGION_VARIABLE_PLACEHOLDER.equals(region = (String)config.get(RESOURCE_REGION))) {
            config.put(RESOURCE_REGION_VARIABLE_KEY, null);
        }
        return config;
    }

    private Map<String, String> getAWSConnectorMap() {
        LinkedHashMap<String, String> awsConnectorMap = new LinkedHashMap<String, String>();
        if (null != this.awsConnectorService2) {
            try {
                List<AWSConnectorDTO2> connectors = this.awsConnectorService2.getConnectors(AWSConnectorScope.SYSTEM);
                String selectRequest = this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsConnector.selectRequest");
                awsConnectorMap.put(String.valueOf(-1), selectRequest);
                for (AWSConnectorDTO2 awsConnectorEntity : connectors) {
                    awsConnectorMap.put(awsConnectorEntity.getId(), awsConnectorEntity.getName());
                }
                String variablePlaceholder = this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsCredentialsSourceOptionIfawsConnectorVariable");
                awsConnectorMap.put(AWS_CONNECTOR_VARIABLE_KEY, variablePlaceholder);
            }
            catch (LicenseException le) {
                String licenseError = this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsConnector.missingLicense");
                awsConnectorMap.put(String.valueOf(-1), licenseError);
            }
        } else {
            log.error("Missing injected dependency on AWSConnectorService2.");
        }
        return awsConnectorMap;
    }

    protected StringBuilder createMessages() {
        StringBuilder messages = new StringBuilder();
        try {
            this.licenseHelper.ensureValidLicense();
        }
        catch (LicenseException le) {
            AUIMessage message = this.licenseHelper.createAUIErrorMessage(le, AUIMessage.Type.WARNING, false);
            messages.append(message.asHtml());
        }
        return messages;
    }

    private Map<String, String> getCredentialsSourcesMap() {
        LinkedHashMap<String, String> sourcesMap = new LinkedHashMap<String, String>();
        sourcesMap.put("IFAWS_CONNECTOR", this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsCredentialsSourceOptionIfawsConnector"));
        sourcesMap.put(AWS_CREDENTIALS_SOURCE_IAM_ROLE_AGENTS, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.credentialsvariables.awsCredentialsSourceOptionIamRoleAgents"));
        return sourcesMap;
    }

    private boolean hasIfawsConnectors() {
        return this.getAWSConnectorMap().size() > 1;
    }

    private void validateVariableScope(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String variableScopeString = params.getString(VARIABLE_SCOPE);
        if (StringUtils.isBlank((String)variableScopeString)) {
            return;
        }
        try {
            VariableScope scope = VariableScope.valueOf(variableScopeString);
            return;
        }
        catch (Exception e) {
            errorCollection.addError(VARIABLE_SCOPE, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.variables.scope.error"));
            return;
        }
    }

    private void validateVariableNamespace(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String variableNamespace = params.getString(VARIABLE_NAMESPACE);
        if (StringUtils.isBlank((String)variableNamespace)) {
            return;
        }
        if (!BaseTaskConfigurator.isValidVariableNamespace(variableNamespace)) {
            errorCollection.addError(VARIABLE_NAMESPACE, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.variables.namespace.error"));
            return;
        }
    }

    public static boolean isValidVariableNamespace(String candidate) {
        return null != candidate && candidate.matches(VARIABLE_KEY_PATTERN);
    }
}

