AJS.toInit(function () {
    var contextPath = AJS.contextPath();
    var connectorIdPlaceholder = AJS.$("#ifaws-connector-id").text();

    function copyAndShowConnectorId(connectorId) {
        AJS.$("#ifaws-connector-id-wrapper").removeClass("ifaws-visibility-hidden");
        AJS.$("#ifaws-connector-id").text(connectorId);
    }

    function clearAndHideConnectorId() {
        AJS.$("#ifaws-connector-id-wrapper").addClass("ifaws-visibility-hidden");
        AJS.$("#ifaws-connector-id").text(connectorIdPlaceholder);
    }

    function isUUID(candidate) {
        var uuidRegex = new RegExp("^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$");
        return uuidRegex.test(candidate);
    }

    function evaluateConnectorSelection() {
        var selectedConnectorValue = AJS.$("#awsConnectorId").val();
        if (isUUID(selectedConnectorValue)) {
            copyAndShowConnectorId(selectedConnectorValue);
        }
        else {
            clearAndHideConnectorId();
        }
    }

    // Trigger clipboard functionality for connector ids
    var ifawsClipboard = new Clipboard("#ifaws-connector-id-copy-trigger", {
        target : function(trigger) {
            return trigger.previousElementSibling;
        }
    });
    // Register adjustment on selection change
    AJS.$("#awsConnectorId").change(function() {
        evaluateConnectorSelection();
    });
    // Bootstrap to current selection
    evaluateConnectorSelection();
});