AJS.toInit(function () {
    var createAccountDiscoveryDialog = AJS.InlineDialog(AJS.$("#aws-account-add"), "create-account-discovery",
        function(content, trigger, showPopup) {
            content.append(AJS.$("<a/>")
                    .css({"float":"right"})
                    .click(function() {
                        createAccountDiscoveryDialog.hide();
                    })
                    .append("<span title=\"Close\" class=\"aui-icon aui-icon-close\">Close</span>")
            );
            content.append(AJS.$("<h3/>")
                .css({"display":"inline"})
                    .append(AJS.I18n.getText("ifaws.configAWSConnectorEdit.account.userHint.title"))
            );
            content.append(AJS.$("<p/>")
                    .append(AJS.I18n.getText("ifaws.configAWSConnectorEdit.account.userHint.message"))
            );
            content.css({"padding":"20px"})
            showPopup();
            return false;
        },
        {
            noBind: true,
            hideDelay: null,
            fadeTime: 2000,
            persistent: false
        }
    );

    if (AJS.$("#aws-account-id > option").length < 2) {
        createAccountDiscoveryDialog.show();
        AJS.$("#aws-account-add").click(function() {
            createAccountDiscoveryDialog.hide();
        });
    }

    var awsAccountIdChanged = function(e) {
        var ec2PlaceholderAccountId = AJS.$('#aws-account-id').data('iamRoleForEc2AccountId');
        // Only relevant if we have an account id (otherwise feature is not active)
        if (ec2PlaceholderAccountId.length > 0) {
            var selected = AJS.$('#aws-account-id').val();
            if (selected === ec2PlaceholderAccountId) {
                // Disable all but Assume Role and Provided
                AJS.$('option[value="ASSUME_ROLE"]')
                    .removeAttr('disabled')
                    .siblings().attr('disabled', 'disabled');
                AJS.$('option[value="PROVIDED"]')
                    .removeAttr('disabled');
            }
            else {
                // Disable Provided, enable all others
                AJS.$('option[value="PROVIDED"]').attr('disabled', 'disabled')
                    .siblings().removeAttr('disabled');
            }
        }
    }

    var awsTypeChanged = function(e) {
        var nonHiddenClass = ".ifaws-show-on-type-";
        var selectedType = AJS.$("#aws-connector-type");
        if (selectedType.length > 0) {
            var selectedType = selectedType.val();
            nonHiddenClass = nonHiddenClass + selectedType.replace("_", "-").toLowerCase();
        }
        AJS.$(".ifaws-toggle-on-type").not(nonHiddenClass).slideUp("fast");
        AJS.$(".ifaws-toggle-on-type" + nonHiddenClass).slideDown("fast");
        // NOTE/KLDGE: Need to reevaluate the omit checkbox, if type is federated
        if ("FEDERATION_TOKEN" == selectedType) {
          iamPolicyOmitChanged(e);
        }
    }

    var iamPolicyOmitChanged = function(e) {
      var hideClass = ".ifaws-hide-on-policy-omit";
      var isOmitPolicyChecked = AJS.$("#allowEmptyIamPolicy").prop("checked");
      if (isOmitPolicyChecked) {
        AJS.$(".ifaws-toggle-on-policy-omit" + hideClass).slideUp("fast");
      }
      else {
        AJS.$(".ifaws-toggle-on-policy-omit" + hideClass).slideDown("fast");
      }
    }

    var iamPolicyExampleClicked = function(e) {
        e.preventDefault();
        var exampleCode = AJS.$(this).closest("li").children("code").text();
        AJS.$("#iamPolicy").text(exampleCode);
    }

    initPolicyExamplesDialog = function(x) {
        this.popup.find(".ifaws-iam-policy-example")
            .attr("title", AJS.I18n.getText("ifaws.connectorEdit.policyExamples.title"))
            .click(iamPolicyExampleClicked);
    }

    var iamPolicyArnsExampleClicked = function(e) {
      e.preventDefault();
      var exampleCode = AJS.$(this).closest("li").children("code").text();
      // NOTE: The Select2 field conversion/manipulation does not allow for straight setting on the input field, we need to go via data manipulation:
      var dataArray = AJS.$("#policyArns").select2("data");
      if (!Array.isArray(dataArray)) {
        dataArray = [];
      }
      var objectToAdd = {"id": exampleCode, "text": exampleCode};
      dataArray.push(objectToAdd);
      // NOTE: Not properly documented, but both 'val' and 'data' method invocations take an optional boolean 'triggerChange' parameter defaulting to false,
      // thus needs to be passed here to ensure our follow up logic gets invoked
      AJS.$("#policyArns").select2("data", dataArray, true);
    }

    initPolicyArnsExamplesDialog = function(x) {
      this.popup.find(".ifaws-iam-policy-arns-example")
      .attr("title", AJS.I18n.getText("ifaws.connectorEdit.policyArnsExamples.title"))
      .click(iamPolicyArnsExampleClicked);
    }

    var pathToStaticHTML = AJS.$("meta[name=ifaws-path-to-static-html]").attr("content");

    AJS.InlineDialog(AJS.$("#iamPolicyExampleTrigger"), "iam-policy-examples", pathToStaticHTML + "inlineDialogPolicyExamples.html", {width: 500, initCallback: initPolicyExamplesDialog});
    AJS.InlineDialog(AJS.$("#iamPolicyArnsExampleTrigger"), "iam-policy-arns-examples", pathToStaticHTML + "inlineDialogPolicyArnsExamples.html", {width: 500, initCallback: initPolicyArnsExamplesDialog});

    AJS.$("#principleTypeExplanationTrigger").css({"cursor":"pointer"});
    AJS.InlineDialog(AJS.$("#principleTypeExplanationTrigger"), "principal-type-explanations", pathToStaticHTML + "inlineDialogTypeExplanation.html", {width: 500});

    AJS.$("#systemScopeExplanationTrigger").css({"cursor":"pointer"});
    AJS.InlineDialog(AJS.$("#systemScopeExplanationTrigger"), "system-scope-explanations", pathToStaticHTML + "inlineDialogSystemScopeExplanation.html", {width: 500});

    AJS.$("#durationSecondsMaxExplanationTrigger").css({"cursor":"pointer"});
    AJS.InlineDialog(AJS.$("#durationSecondsMaxExplanationTrigger"), "duration-seconds-explanations", pathToStaticHTML + "inlineDialogDurationExplanation.html", {width: 500});

    // AJS.$("#aws-account-id").change(awsAccountIdChanged);
    AJS.$("#aws-connector-type").change(awsTypeChanged);
    AJS.$("#allowEmptyIamPolicy").change(iamPolicyOmitChanged);
    // awsAccountIdChanged();
    awsTypeChanged();
});
