/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ui;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.utoolity.atlassian.dry.AUIMessage;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.dry.PluginInfo;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigAWSConnectorDeleteServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final WebSudoManager webSudoManager;
    private final LicenseHelper licenseHelper;
    private final TemplateRenderer renderer;
    private final I18nResolver i18n;
    private final AWSConnectorPersistenceService awsConnectorPersistenceService;

    @Autowired
    public ConfigAWSConnectorDeleteServlet(@ComponentImport WebSudoManager webSudoManager, LicenseHelper licenseHelper, @ComponentImport TemplateRenderer renderer, @ComponentImport I18nResolver i18n, AWSConnectorPersistenceService awsConnectorPersistenceService) {
        this.webSudoManager = webSudoManager;
        this.licenseHelper = licenseHelper;
        this.renderer = renderer;
        this.i18n = i18n;
        this.awsConnectorPersistenceService = awsConnectorPersistenceService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String idParam = this.extractIdParam(request);
            if (null == idParam) {
                response.sendError(404);
                return;
            }
            AWSConnectorEntity awsConnector = this.getAWSConnector(idParam);
            if (null == awsConnector) {
                response.sendError(404);
                return;
            }
            ArrayList<AUIMessage> messages = new ArrayList<AUIMessage>();
            HashMap errors = new HashMap();
            Boolean readOnly = false;
            try {
                this.licenseHelper.ensureValidLicense();
            }
            catch (LicenseException le) {
                readOnly = true;
                messages.add(this.licenseHelper.createAUIErrorMessage(le, AUIMessage.Type.WARNING, true));
            }
            if (!readOnly.booleanValue()) {
                AUIMessage message = new AUIMessage(AUIMessage.Type.WARNING, this.i18n.getText("ifaws.configAWSConnectorDelete.confirmation.title"), this.i18n.getText("ifaws.configAWSConnectorDelete.confirmation.body"));
                messages.add(message);
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("awsConnector", awsConnector);
            context.put("messages", messages);
            context.put("errors", errors);
            context.put("readOnly", readOnly);
            context.put("pluginKey", PluginInfo.PLUGIN_KEY);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render("net/utoolity/atlassian/ifaws/templates/configAWSConnectorDelete.vm", context, (Writer)response.getWriter());
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String idParam = this.extractIdParam(request);
            if (null == idParam) {
                response.sendError(404);
                return;
            }
            AWSConnectorEntity awsConnector = this.getAWSConnector(idParam);
            if (null == awsConnector) {
                response.sendError(404);
                return;
            }
            ArrayList<AUIMessage> messages = new ArrayList<AUIMessage>();
            HashMap errors = new HashMap();
            Boolean readOnly = false;
            try {
                this.licenseHelper.ensureValidLicense();
            }
            catch (LicenseException le) {
                readOnly = true;
                response.sendError(409);
                return;
            }
            String postedIdParam = request.getParameter("id");
            if (null == postedIdParam || !postedIdParam.equals(awsConnector.getId())) {
                response.sendError(409);
                return;
            }
            try {
                this.awsConnectorPersistenceService.delete(awsConnector);
                response.sendRedirect("../../aws-connector");
            }
            catch (RuntimeException e) {
                AUIMessage message = new AUIMessage(AUIMessage.Type.WARNING, this.i18n.getText("ifaws.configAWSConnectorDelete.failure.title"), e.getLocalizedMessage());
                messages.add(message);
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("awsConnector", awsConnector);
            context.put("messages", messages);
            context.put("errors", errors);
            context.put("readOnly", readOnly);
            context.put("pluginKey", PluginInfo.PLUGIN_KEY);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render("net/utoolity/atlassian/ifaws/templates/configAWSConnectorDelete.vm", context, (Writer)response.getWriter());
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private AWSConnectorEntity getAWSConnector(String idParam) {
        try {
            return this.awsConnectorPersistenceService.getById(idParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String extractIdParam(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (null == pathInfo) {
            return null;
        }
        String[] pathInfoParts = pathInfo.split("/");
        if (pathInfoParts.length != 6) {
            return null;
        }
        return pathInfoParts[4];
    }
}

