/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ao;

public enum DefaultCloudProvider {
    AWS("aws", "AWS Standard", "https://sts.amazonaws.com", "https://console.aws.amazon.com/", "https://signin.aws.amazon.com/federation", "aws"),
    AWS_US_GOV("aws.us-gov", "AWS GovCloud (US)", "https://sts.us-gov-west-1.amazonaws.com", "https://console.amazonaws-us-gov.com/", "https://signin.amazonaws-us-gov.com/federation", "aws-us-gov"),
    AWS_CN("aws.cn", "AWS China", "https://sts.cn-north-1.amazonaws.com.cn", "https://console.amazonaws.cn/", "https://signin.amazonaws.cn/federation", "aws-cn");

    private final String key;
    private final String displayName;
    private final String stsEndpointURL;
    private final String managementConsoleURL;
    private final String signinURL;
    private final String partitionKey;

    private DefaultCloudProvider(String key, String displayName, String stsEndpointURL, String managementConsoleURL, String signinURL, String partitionKey) {
        this.key = key;
        this.displayName = displayName;
        this.stsEndpointURL = stsEndpointURL;
        this.managementConsoleURL = managementConsoleURL;
        this.signinURL = signinURL;
        this.partitionKey = partitionKey;
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getStsEndpointURL() {
        return this.stsEndpointURL;
    }

    public String getManagementConsoleURL() {
        return this.managementConsoleURL;
    }

    public String getSigninURL() {
        return this.signinURL;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public static DefaultCloudProvider getByKey(String cloudProviderKey) {
        DefaultCloudProvider match = null;
        for (DefaultCloudProvider defaultCloudProvider : DefaultCloudProvider.values()) {
            if (!defaultCloudProvider.getKey().equals(cloudProviderKey)) continue;
            match = defaultCloudProvider;
            break;
        }
        if (null == match) {
            throw new RuntimeException("Unknown cloud provider key: " + cloudProviderKey);
        }
        return match;
    }

    public static DefaultCloudProvider getByPartitionKey(String partitionKey) {
        DefaultCloudProvider match = null;
        for (DefaultCloudProvider defaultCloudProvider : DefaultCloudProvider.values()) {
            if (!defaultCloudProvider.getPartitionKey().equals(partitionKey)) continue;
            match = defaultCloudProvider;
            break;
        }
        if (null == match) {
            throw new RuntimeException("Unknown partition key: " + partitionKey);
        }
        return match;
    }
}

