/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws;

import com.atlassian.sal.api.ApplicationProperties;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import net.utoolity.atlassian.dry.ApplicationVersionComparator;
import net.utoolity.atlassian.dry.ExtendedApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedApplicationPropertiesImpl
implements ExtendedApplicationProperties {
    private static final Logger log = LoggerFactory.getLogger(ExtendedApplicationPropertiesImpl.class);
    private final ApplicationProperties applicationProperties;
    public static String BAMBOO_VERSION_FOR_SAL_4_1_AVAILABILITY = "7.1.0";

    public ExtendedApplicationPropertiesImpl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public File getSharedHomeDirectory() {
        if (this.canUseNewSalMethods()) {
            try {
                Optional homeDirOptional = this.applicationProperties.getSharedHomeDirectory();
                if (homeDirOptional.isPresent()) {
                    return ((Path)homeDirOptional.get()).toFile();
                }
                return ((Path)this.applicationProperties.getLocalHomeDirectory().get()).toFile();
            }
            catch (NoSuchMethodError e) {
                log.warn("... unexpected NoSuchMethodError for getSharedHomeDirectory(), assuming SAL to old despite Bamboo version suggesting otherwise");
                return this.applicationProperties.getHomeDirectory();
            }
        }
        return this.applicationProperties.getHomeDirectory();
    }

    @Override
    public File getLocalHomeDirectory() {
        if (this.canUseNewSalMethods()) {
            try {
                return ((Path)this.applicationProperties.getLocalHomeDirectory().get()).toFile();
            }
            catch (NoSuchMethodError e) {
                log.warn("... unexpected NoSuchMethodError for getSharedHomeDirectory(), assuming SAL to old despite Bamboo version suggesting otherwise");
                return this.applicationProperties.getHomeDirectory();
            }
        }
        return this.applicationProperties.getHomeDirectory();
    }

    private boolean canUseNewSalMethods() {
        ApplicationVersionComparator versionComparator = new ApplicationVersionComparator(this.applicationProperties);
        return versionComparator.isHigherOrEqualTo(BAMBOO_VERSION_FOR_SAL_4_1_AVAILABILITY);
    }
}

