/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.v2;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.utoolity.atlassian.ifaws.AWSConsoleLoginConnectorFilter;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.rest.common.ErrorResponseDTO;
import net.utoolity.atlassian.ifaws.rest.v2.MarkupFragmentDTO;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Path(value="/dropdown/aws-resources-menu")
public class DropdownAwsResourcesMenuResource {
    private final TemplateRenderer renderer;
    private final I18nResolver i18n;
    private final ApplicationProperties applicationProperties;
    private final AWSConnectorService2 awsConnectorService2;

    @Autowired
    public DropdownAwsResourcesMenuResource(@ComponentImport TemplateRenderer renderer, @ComponentImport I18nResolver i18n, @ComponentImport ApplicationProperties applicationProperties, AWSConnectorService2 awsConnectorService2) {
        this.renderer = renderer;
        this.i18n = i18n;
        this.applicationProperties = applicationProperties;
        this.awsConnectorService2 = awsConnectorService2;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getMenuMarkup() {
        ArrayList messages = new ArrayList();
        List<Object> availableConnectors = new ArrayList();
        AWSConsoleLoginConnectorFilter loginConnectorFilter = new AWSConsoleLoginConnectorFilter(this.awsConnectorService2);
        availableConnectors = loginConnectorFilter.getAvailableSSOConnectors();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("messages", messages);
        context.put("availableConnectors", availableConnectors);
        String pluginServletPathWithContext = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/plugins/servlet/identity-federation-for-aws";
        context.put("pathToProxyServlet", pluginServletPathWithContext + "/aws-console-login");
        context.put("pathToOverviewServlet", pluginServletPathWithContext + "/configuration/aws-connector");
        context.put("emptyConnectorMessage", this.i18n.getText("ifaws.awsResourceSection.message.noLinks"));
        StringWriter stringWriter = new StringWriter();
        try {
            this.renderer.render("net/utoolity/atlassian/ifaws/templates/awsConsoleLinkDropdown.vm", context, (Writer)stringWriter);
            String menuMarkup = stringWriter.toString();
            MarkupFragmentDTO markupFragmentDTO = MarkupFragmentDTO.fromString(menuMarkup);
            return Response.ok((Object)markupFragmentDTO).build();
        }
        catch (Exception e) {
            ErrorResponseDTO responseEntity = new ErrorResponseDTO((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "500", e.getClass().getSimpleName());
            return Response.status((Response.StatusType)responseEntity.getStatus()).entity((Object)responseEntity).build();
        }
    }
}

