/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.dry;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginDetector {
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLISECONDS = 1000;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS = 1000;
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private static final Logger log = LoggerFactory.getLogger(PluginDetector.class);

    @Autowired
    public PluginDetector(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport ApplicationProperties applicationProperties) {
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
    }

    public boolean isPluginInstalled(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        return null != plugin && !PluginState.UNINSTALLED.equals((Object)plugin.getPluginState());
    }

    public boolean isPluginEnabled(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        return null != plugin && PluginState.ENABLED.equals((Object)plugin.getPluginState());
    }

    public boolean isPluginLicensed(String licenseStatusUrl) {
        boolean isLicensed = true;
        String baseUrl = StringUtils.strip((String)this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE), (String)"/");
        licenseStatusUrl = StringUtils.strip((String)licenseStatusUrl, (String)"/");
        String fullLicenseStatusUrl = baseUrl + "/" + licenseStatusUrl;
        log.debug("Checking for app license status information at: " + fullLicenseStatusUrl);
        try {
            isLicensed = (Boolean)Request.Head((String)fullLicenseStatusUrl).connectTimeout(1000).socketTimeout(1000).execute().handleResponse((ResponseHandler)new ResponseHandler<Boolean>(){

                public Boolean handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    Boolean isLicensed = true;
                    StatusLine statusLine = response.getStatusLine();
                    log.debug("... got response status: " + statusLine.toString());
                    int statusCode = statusLine.getStatusCode();
                    if (statusCode == 402) {
                        isLicensed = false;
                    }
                    return isLicensed;
                }
            });
        }
        catch (ClientProtocolException e) {
            log.debug(e.getMessage());
        }
        catch (IOException e) {
            log.debug(e.getMessage());
        }
        return isLicensed;
    }
}

