/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.api.v1.services;

import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.collabsoft.plugins.bamboo.api.v1.entities.AutoRetryConfig;
import net.collabsoft.plugins.bamboo.api.v1.repositories.AutoRetryDAO;
import net.collabsoft.plugins.bamboo.api.v1.services.Service;
import net.collabsoft.plugins.bamboo.autoretry.AutoRetryManager;
import net.collabsoft.plugins.bamboo.autoretry.AutoRetryStatus;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class AutoRetryService
implements Service<AutoRetryConfig> {
    private final AutoRetryDAO repository;
    private final AutoRetryManager autoRetryManager;

    @Autowired
    AutoRetryService(AutoRetryDAO dao, AutoRetryManager autoRetryManager) {
        this.repository = dao;
        this.autoRetryManager = autoRetryManager;
    }

    @Override
    public AutoRetryConfig getOrCreate(int id) {
        return this.repository.getOrCreate(id);
    }

    @Override
    public AutoRetryConfig findById(int id) {
        return this.repository.get(id);
    }

    @Override
    public List<AutoRetryConfig> findAllByProjectKey(String projectKey) {
        return Arrays.stream(this.repository.get(projectKey)).collect(Collectors.toList());
    }

    public AutoRetryConfig findByProjectAndPlanKey(String projectKey, String planKey) {
        return this.repository.get(projectKey, planKey);
    }

    @Override
    public void deleteById(int id) {
        this.repository.delete(id);
    }

    public AutoRetryStatus getAutoRetryStatusFor(String planResultKey) {
        return this.autoRetryManager.getAutoRetryStatusFor(planResultKey);
    }
}

