/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.api.v1.repositories;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import java.util.Arrays;
import net.collabsoft.plugins.bamboo.api.v1.entities.EnrichedDashboardItem;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class EnrichedDashboardDAO {
    private final ActiveObjects activeObjects;

    @Autowired
    EnrichedDashboardDAO(@BambooImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public EnrichedDashboardItem[] get() {
        return (EnrichedDashboardItem[])this.activeObjects.find(EnrichedDashboardItem.class);
    }

    public EnrichedDashboardItem[] get(String projectKey) {
        return (EnrichedDashboardItem[])this.activeObjects.find(EnrichedDashboardItem.class, Query.select().where("PROJECT_KEY = ?", new Object[]{projectKey}));
    }

    public EnrichedDashboardItem get(String projectKey, String name) {
        EnrichedDashboardItem[] items = (EnrichedDashboardItem[])this.activeObjects.find(EnrichedDashboardItem.class, Query.select().where("PROJECT_KEY = ? AND NAME = ?", new Object[]{projectKey, name}));
        return items.length > 0 ? items[0] : null;
    }

    public EnrichedDashboardItem get(int id) {
        return (EnrichedDashboardItem)this.activeObjects.get(EnrichedDashboardItem.class, (Object)id);
    }

    public EnrichedDashboardItem getOrCreate(int id) {
        EnrichedDashboardItem item = this.get(id);
        return item != null ? item : (EnrichedDashboardItem)this.activeObjects.create(EnrichedDashboardItem.class, new DBParam[0]);
    }

    public void reset() {
        EnrichedDashboardItem[] items = (EnrichedDashboardItem[])this.activeObjects.find(EnrichedDashboardItem.class);
        Arrays.stream(items).forEach(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
    }

    public void delete(int id) {
        EnrichedDashboardItem item = this.get(id);
        if (item != null) {
            this.delete(item);
        }
    }

    public void delete(EnrichedDashboardItem item) {
        this.activeObjects.delete(new RawEntity[]{item});
    }
}

