/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.api.v1.repositories;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import java.util.Arrays;
import net.collabsoft.plugins.bamboo.api.v1.entities.AutoRetryConfig;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class AutoRetryDAO {
    private final ActiveObjects activeObjects;

    @Autowired
    AutoRetryDAO(@BambooImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public AutoRetryConfig[] get() {
        return (AutoRetryConfig[])this.activeObjects.find(AutoRetryConfig.class);
    }

    public AutoRetryConfig[] get(String projectKey) {
        return (AutoRetryConfig[])this.activeObjects.find(AutoRetryConfig.class, Query.select().where("PROJECT_KEY = ?", new Object[]{projectKey}));
    }

    public AutoRetryConfig get(String projectKey, String planKey) {
        AutoRetryConfig[] items = (AutoRetryConfig[])this.activeObjects.find(AutoRetryConfig.class, Query.select().where("PROJECT_KEY = ? AND PLAN_KEY = ?", new Object[]{projectKey, planKey}));
        return items.length > 0 ? items[0] : null;
    }

    public AutoRetryConfig get(int id) {
        if (id <= 0) {
            return null;
        }
        return (AutoRetryConfig)this.activeObjects.get(AutoRetryConfig.class, (Object)id);
    }

    public AutoRetryConfig getOrCreate(int id) {
        AutoRetryConfig item = this.get(id);
        return item != null ? item : (AutoRetryConfig)this.activeObjects.create(AutoRetryConfig.class, new DBParam[0]);
    }

    public void reset() {
        AutoRetryConfig[] items = (AutoRetryConfig[])this.activeObjects.find(AutoRetryConfig.class);
        Arrays.stream(items).forEach(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
    }

    public void delete(int id) {
        AutoRetryConfig item = this.get(id);
        if (item != null) {
            this.delete(item);
        }
    }

    public void delete(AutoRetryConfig item) {
        this.activeObjects.delete(new RawEntity[]{item});
    }
}

