/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.api.v1.dto;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.VariableDefinition;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ProjectVariableDTO {
    private Long id;
    private String key;
    private String value;
    private String projectKey;

    public ProjectVariableDTO() {
    }

    public ProjectVariableDTO(VariableDefinition variableDefinition) {
        this.id = variableDefinition.getId();
        this.key = variableDefinition.getKey();
        this.value = PasswordMaskingUtils.shouldBeMasked((VariableDefinition)variableDefinition) ? "********" : variableDefinition.getValue();
        Plan plan = variableDefinition.getPlan();
        if (plan != null) {
            this.projectKey = plan.getProject().getKey();
            this.key = this.key.substring(this.projectKey.length() + 1);
        }
    }

    public ProjectVariableDTO(VariableDefinition variableDefinition, String projectKey) {
        this(variableDefinition);
        this.projectKey = projectKey;
        if (this.key != null) {
            this.key = this.key.substring(projectKey.length() + 1);
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }
}

