/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.api.v1.controllers;

import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.collabsoft.plugins.bamboo.api.v1.controllers.AbstractController;
import net.collabsoft.plugins.bamboo.api.v1.dto.AutoRetryConfigDTO;
import net.collabsoft.plugins.bamboo.api.v1.entities.AutoRetryConfig;
import net.collabsoft.plugins.bamboo.api.v1.services.AutoRetryService;
import net.collabsoft.plugins.bamboo.autoretry.AutoRetryStatus;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/autoretry")
public class AutoRetryController
extends AbstractController<AutoRetryConfig> {
    @Inject
    @Autowired
    AutoRetryController(AutoRetryService autoRetryService, @BambooImport BambooPermissionManager bambooPermissionManager, @BambooImport ProjectManager projectManager) {
        super(autoRetryService, projectManager, bambooPermissionManager);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/list")
    public Response list(@QueryParam(value="projectKey") String projectKey) {
        if (!this.hasProjectAdministrationRights(projectKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List autoRetryConfigs = this.service.findAllByProjectKey(projectKey);
        List result = autoRetryConfigs.stream().map(AutoRetryConfigDTO::new).collect(Collectors.toList());
        return Response.ok(result).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/list")
    public Response create(AutoRetryConfigDTO item) {
        if (item.getId() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.hasProjectAdministrationRights(item.getProjectKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        AutoRetryConfig autoRetryConfig = this.updateOrCreate(item);
        AutoRetryConfigDTO dto = new AutoRetryConfigDTO(autoRetryConfig);
        return Response.ok((Object)dto).build();
    }

    @GET
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") int id) {
        AutoRetryConfig autoRetryConfig = (AutoRetryConfig)this.service.findById(id);
        if (autoRetryConfig != null) {
            if (!this.hasProjectAdministrationRights(autoRetryConfig.getProjectKey())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            AutoRetryConfigDTO result = new AutoRetryConfigDTO(autoRetryConfig);
            return Response.ok((Object)result).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    @Path(value="/{id}")
    public Response update(@PathParam(value="id") int id, AutoRetryConfigDTO item) {
        if (id != item.getId()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        AutoRetryConfig autoRetryConfig = (AutoRetryConfig)this.service.findById(id);
        if (autoRetryConfig == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.hasProjectAdministrationRights(autoRetryConfig.getProjectKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        autoRetryConfig = this.updateOrCreate(item);
        AutoRetryConfigDTO dto = new AutoRetryConfigDTO(autoRetryConfig);
        return Response.ok((Object)dto).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") int id) {
        return this.deleteById(id);
    }

    @GET
    @Path(value="/status/{planResultKey}")
    public AutoRetryStatus status(@PathParam(value="planResultKey") String planResultKey) {
        return ((AutoRetryService)this.service).getAutoRetryStatusFor(planResultKey);
    }

    private AutoRetryConfig updateOrCreate(AutoRetryConfigDTO item) {
        AutoRetryConfig autoRetryConfig = (AutoRetryConfig)this.service.getOrCreate(item.getId());
        autoRetryConfig.setName(item.getName());
        autoRetryConfig.setPlanKey(item.getPlanKey());
        autoRetryConfig.setProjectKey(item.getProjectKey());
        autoRetryConfig.setTimeout(item.getTimeout());
        autoRetryConfig.setRetries(item.getRetries());
        autoRetryConfig.setRerun(item.isRerun());
        autoRetryConfig.save();
        return autoRetryConfig;
    }
}

