/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.api.v1.controllers;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import javax.ws.rs.core.Response;
import net.collabsoft.plugins.bamboo.api.v1.entities.AbstractEntity;
import net.collabsoft.plugins.bamboo.api.v1.services.Service;

public abstract class AbstractController<T extends AbstractEntity> {
    protected Service<T> service;
    private final ProjectManager projectManager;
    private final BambooPermissionManager bambooPermissionManager;

    AbstractController(@BambooImport ProjectManager projectManager, @BambooImport BambooPermissionManager bambooPermissionManager) {
        this.projectManager = projectManager;
        this.bambooPermissionManager = bambooPermissionManager;
    }

    AbstractController(Service<T> service, ProjectManager projectManager, BambooPermissionManager bambooPermissionManager) {
        this(projectManager, bambooPermissionManager);
        this.service = service;
    }

    Response deleteById(int id) {
        T item = this.service.findById(id);
        if (item == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.hasProjectAdministrationRights(item.getProjectKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.service.deleteById(id);
        return Response.noContent().build();
    }

    String toProjectKey(String key) {
        if (key.contains("-")) {
            PlanKey planKey = PlanKeys.getPlanKey((String)key);
            return PlanKeys.getProjectKeyPart((PlanKey)planKey);
        }
        return key;
    }

    boolean hasProjectAdministrationRights(String key) {
        String projectKey = this.toProjectKey(key);
        Project project = this.projectManager.getProjectByKey(projectKey);
        return this.bambooPermissionManager.hasProjectEditPermission(project);
    }
}

