/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.ProjectAware;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class UBWebAction
extends BambooActionSupport
implements ProjectAware {
    private static final String PLUGIN_KEY = "net.collabsoft.plugins.bamboo.utilityBelt";
    private static final String WEB_ITEM_SOURCE_QUERY_PARAM = "s";
    private final PluginAccessor pluginAccessor;
    private Project project;
    private String projectKey;
    protected Map<String, String> params = new HashMap<String, String>();

    @Autowired
    UBWebAction(@BambooImport @Qualifier(value="pluginAccessor") PluginAccessor pluginAccessor, @BambooImport ProjectManager projectManager, @BambooImport FeatureManager featureManager, @BambooImport BambooPermissionManager bambooPermissionManager) {
        this.pluginAccessor = pluginAccessor;
        this.projectManager = projectManager;
        this.featureManager = featureManager;
        this.bambooPermissionManager = bambooPermissionManager;
    }

    @Nullable
    public Project getProject() {
        String projectKey;
        if (this.project == null && (projectKey = this.getProjectKey()) != null) {
            this.project = this.projectManager.getProjectByKey(projectKey);
        }
        return this.project;
    }

    public String getProjectKey() {
        if (this.projectKey == null) {
            this.projectKey = this.params.get("projectKey");
        }
        return this.projectKey;
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    public boolean isProjectWithPlans() {
        List emptyProjects = new ArrayList();
        try {
            Method getEmptyProjects = this.projectManager.getClass().getMethod("getEmptyProjects", new Class[0]);
            emptyProjects = (List)getEmptyProjects.invoke((Object)this.projectManager, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return !emptyProjects.contains(this.project);
    }

    public String execute() throws IOException {
        Project project;
        HttpServletRequest request = ServletActionContext.getRequest();
        Map parameters = request.getParameterMap();
        parameters.forEach((name, values) -> this.params.put((String)name, values[0]));
        if (this.params.containsKey(WEB_ITEM_SOURCE_QUERY_PARAM)) {
            String moduleKey = String.format("%s:%s", PLUGIN_KEY, this.params.get(WEB_ITEM_SOURCE_QUERY_PARAM));
            ModuleDescriptor descriptor = this.pluginAccessor.getEnabledPluginModule(moduleKey);
            WebItemModuleDescriptor item = (WebItemModuleDescriptor)descriptor;
            Map webItemParams = item.getParams();
            this.params.putAll(webItemParams);
        }
        if (!this.params.containsKey("title")) {
            this.params.put("title", "Utility Belt for Bamboo");
        }
        if (this.params.containsKey("projectKey") && !this.bambooPermissionManager.hasProjectEditPermission(project = this.projectManager.getProjectByKey(this.params.get("projectKey")))) {
            ServletActionContext.getResponse().sendRedirect(this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl() + "/userlogin!doDefault.action?os_destination=" + EscapeChars.forUrl((String)(request.getServletPath() + request.getPathInfo())));
        }
        return "success";
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public Map<String, String> getParams() {
        return this.params;
    }
}

