/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.SimpleLogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionContextImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.spring.container.ContainerManager;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class UBPreBuildAction
extends AbstractBuildTask
implements CustomPreBuildAction {
    private static final Logger log = Logger.getLogger(UBPreBuildAction.class);

    public void init(@NotNull BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public ErrorCollection validate(BuildConfiguration config) {
        return null;
    }

    @NotNull
    public BuildContext call() {
        try {
            Map<String, VariableDefinitionContext> globalVariables = this.findAndReplaceNestedVariables(this.buildContext.getVariableContext().getOriginalVariables());
            HashMap<String, VariableDefinitionContext> localVariables = new HashMap<String, VariableDefinitionContext>(globalVariables);
            String projectKey = this.getProjectKey();
            globalVariables.forEach((key, variableDefinitionContext) -> {
                if (key.startsWith(projectKey)) {
                    key = key.substring(projectKey.length() + 1);
                    if (!this.buildContext.getVariableContext().getOriginalVariables().containsKey(key)) {
                        this.WriteLogEntry("Adding Project Variable '${bamboo." + key + "}' to the substitution list");
                        VariableDefinitionContextImpl substitution = new VariableDefinitionContextImpl(key, variableDefinitionContext.getValue(), variableDefinitionContext.getVariableType());
                        localVariables.put((String)key, (VariableDefinitionContext)substitution);
                    } else {
                        this.WriteLogEntry("Project variable with key '" + key + "' cannot be substituted. A Global Variable with the same key already exists.");
                    }
                }
            });
            localVariables.forEach((key, variableDefinitionContext) -> {
                if (variableDefinitionContext.getValue() != null) {
                    this.buildContext.getVariableContext().addLocalVariable(variableDefinitionContext.getKey(), variableDefinitionContext.getValue());
                }
            });
        }
        catch (Exception exp) {
            this.WriteLogEntry("Utility Belt: an unexpected exception occurred. Please refer to the log files for more information.");
            log.error((Object)"Utility Belt: an unexpected exception occurred.", (Throwable)exp);
        }
        return this.buildContext;
    }

    private String getProjectKey() {
        return PlanKeys.getProjectKeyPart((PlanResultKey)this.buildContext.getPlanResultKey());
    }

    private Map<String, VariableDefinitionContext> findAndReplaceNestedVariables(Map<String, VariableDefinitionContext> variables) {
        try {
            HashMap<String, VariableDefinitionContext> result = new HashMap<String, VariableDefinitionContext>();
            variables.forEach((entryKey, variableDefinitionContext) -> {
                String key = variableDefinitionContext.getKey();
                String value = variableDefinitionContext.getValue();
                result.put(key, (VariableDefinitionContext)new VariableDefinitionContextImpl(key, this.doReplace(key, value), variableDefinitionContext.getVariableType()));
            });
            return result;
        }
        catch (Exception e) {
            log.error((Object)("Nested Variables for Bamboo: an unexpected exception occurred." + e.getMessage()));
            return variables;
        }
    }

    private String doReplace(String key, String value) {
        Pattern regex = Pattern.compile("\\$\\{bamboo\\.(.*?)}");
        Matcher regexMatcher = regex.matcher(value);
        while (regexMatcher.find()) {
            SimpleLogEntry logEntry;
            BuildLogger buildLogger;
            String matchedKey = regexMatcher.group(1);
            String matchedValue = this.getValueForKey(matchedKey);
            if (!value.contains("${bamboo." + matchedKey + "}")) continue;
            if (matchedValue != null) {
                value = value.replace("${bamboo." + matchedKey + "}", matchedValue);
                buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)this.buildContext.getPlanResultKey());
                logEntry = new SimpleLogEntry("Nested Variable found in ${bamboo." + key + "}, replacing '${bamboo." + matchedKey + "}' with '" + matchedValue + "'");
                log.warn((Object)buildLogger.addBuildLogEntry((LogEntry)logEntry));
                value = this.doReplace(key, value);
                continue;
            }
            buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)this.buildContext.getPlanResultKey());
            logEntry = new SimpleLogEntry("Nested Variable found in ${bamboo." + key + "}, however no replacement value found for nested variable '${bamboo." + matchedKey + "}'");
            log.warn((Object)buildLogger.addBuildLogEntry((LogEntry)logEntry));
        }
        return value;
    }

    private String getValueForKey(String key) {
        for (Map.Entry item : this.buildContext.getVariableContext().getOriginalVariables().entrySet()) {
            String variableKey = ((VariableDefinitionContext)item.getValue()).getKey();
            if (!variableKey.equals(key)) continue;
            return ((VariableDefinitionContext)item.getValue()).getValue();
        }
        return null;
    }

    private void WriteLogEntry(String message) {
        BuildLogger buildLogger = this.getBuildLoggerManager().getLogger((ResultKey)this.buildContext.getPlanResultKey());
        SimpleLogEntry logEntry = new SimpleLogEntry(message);
        buildLogger.addBuildLogEntry((LogEntry)logEntry);
    }

    private BuildLoggerManager getBuildLoggerManager() {
        return (BuildLoggerManager)ContainerManager.getComponent((String)"buildLoggerManager");
    }
}

