/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDetectionAction;
import com.atlassian.bamboo.build.BuildDetectionResult;
import com.atlassian.bamboo.build.BuildDetectionResultImpl;
import com.atlassian.bamboo.build.context.BuildContextBuilder;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactory;
import com.atlassian.bamboo.build.context.BuildContextBuilderFactoryImpl;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.plugins.PostChainAction;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.executor.SystemSecurityContextExecutors;
import com.atlassian.bamboo.persistence.HibernateRunner;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanExecutionConfig;
import com.atlassian.bamboo.plan.PlanExecutionConfigImpl;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.plan.artifact.ArtifactContextImpl;
import com.atlassian.bamboo.plan.branch.BranchIntegrationService;
import com.atlassian.bamboo.plan.branch.BranchIntegrationServiceImpl;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.PlanTriggerResult;
import com.atlassian.bamboo.plan.trigger.PlanTriggerResultBuilder;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.SecureTokenService;
import com.atlassian.bamboo.security.SecureTokenServiceImpl;
import com.atlassian.bamboo.util.AcquisitionPolicy;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildKey;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.atlassian.fugue.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import net.collabsoft.plugins.bamboo.autoretry.AutoRetryBuildDetectionAction;
import net.collabsoft.plugins.bamboo.autoretry.AutoRetryManager;
import net.collabsoft.plugins.bamboo.autoretry.AutoRetryStatus;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;

public class UBPostChainAction
implements PostChainAction {
    private static final Logger log = Logger.getLogger(UBPostChainAction.class);
    private final AutoRetryManager autoRetryManager;
    private final PlanManager planManager;
    private final VariableDefinitionManager variableDefinitionManager;
    private final BuildContextBuilderFactory buildContextBuilderFactory;
    private final CachedPlanManager cachedPlanManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final ApplicationContext applicationContext;
    private final PlanExecutionManager planExecutionManager;
    private final SecureTokenService secureTokenService;

    public UBPostChainAction(AutoRetryManager autoRetryManager, @BambooImport CachedPlanManager cachedPlanManager, @BambooImport RepositoryDefinitionManager repositoryDefinitionManager, @BambooImport ApplicationContext applicationContext, @BambooImport PlanManager planManager, @BambooImport VariableDefinitionManager variableDefinitionManager, @BambooImport CredentialsAccessor credentialsAccessor, @BambooImport PlanExecutionManager planExecutionManager, @BambooImport SecureTokenService secureTokenService) throws Exception {
        this.autoRetryManager = autoRetryManager;
        this.planManager = planManager;
        this.variableDefinitionManager = variableDefinitionManager;
        this.cachedPlanManager = cachedPlanManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.applicationContext = applicationContext;
        this.planExecutionManager = planExecutionManager;
        this.buildContextBuilderFactory = new BuildContextBuilderFactoryImpl(this.getBranchIntegrationService(), variableDefinitionManager, credentialsAccessor);
        this.secureTokenService = secureTokenService;
    }

    public void execute(@NotNull ImmutableChain immutableChain, @NotNull ChainResultsSummary chainResultsSummary, @NotNull ChainExecution chainExecution) throws InterruptedException, Exception {
        PlanKey planKey = immutableChain.getPlanKey();
        Plan plan = this.planManager.getPlanByKey(planKey);
        if (plan == null) {
            log.debug((Object)"The plan associated with this chain result no longer exists, aborting retry");
            return;
        }
        AutoRetryStatus autoRetryStatus = this.autoRetryManager.getAutoRetryStatusFor(chainResultsSummary);
        if (autoRetryStatus != null) {
            long autoRetryState = this.autoRetryManager.getAutoRetryState(immutableChain, autoRetryStatus);
            autoRetryStatus.setAutoRetryState(autoRetryState);
            if (autoRetryStatus.getAutoRetryState() == 0L) {
                autoRetryStatus.setAutoRetryState(32L);
                this.triggerRetry(autoRetryStatus, immutableChain, chainResultsSummary, chainExecution, PlanExecutionConfig.PlanExecutionType.RESTART);
            } else if (autoRetryStatus.getAutoRetryState() == 1L) {
                autoRetryStatus.setAutoRetryState(33L);
                this.triggerRetry(autoRetryStatus, immutableChain, chainResultsSummary, chainExecution, PlanExecutionConfig.PlanExecutionType.RERUN);
            } else {
                this.autoRetryManager.setAutoRetryStatus(chainResultsSummary, autoRetryStatus);
            }
        }
    }

    private void triggerRetry(AutoRetryStatus autoRetryStatus, ImmutableChain chain, ChainResultsSummary resultSummary, ChainExecution ce, PlanExecutionConfig.PlanExecutionType restartType) {
        try {
            this.autoRetryManager.setAutoRetryStatus(resultSummary, autoRetryStatus);
            PlanExecutionConfig planExecutionConfig = new PlanExecutionConfigImpl(restartType).setChain(chain).setChainResultSummary(resultSummary).build();
            BuildDetectionAction buildDetectionAction = this.getBuildDetectionAction(chain, resultSummary, ce, planExecutionConfig);
            ListeningExecutorService executorService = SystemSecurityContextExecutors.newSingleThreadExecutor((String)("AutoRetry_" + chain.getPlanKey().getKey()));
            executorService.submit(() -> {
                try {
                    HibernateRunner.runWithHibernateSession(() -> {
                        this.executeRetry(autoRetryStatus, chain, buildDetectionAction);
                        return null;
                    });
                }
                catch (Exception exp) {
                    log.error((Object)"An error occurred while scheduling an auto retry action. Please check the log files for more information.", (Throwable)exp);
                }
            });
            executorService.shutdown();
        }
        catch (Exception exp) {
            log.error((Object)"An error occurred while scheduling an auto retry action. Please check the log files for more information.", (Throwable)exp);
        }
    }

    private void executeRetry(AutoRetryStatus autoRetryStatus, ImmutableChain chain, BuildDetectionAction buildDetectionAction) {
        try {
            Plan plan = this.planManager.getPlanByKey(chain.getPlanKey());
            if (plan == null) {
                return;
            }
            if (autoRetryStatus.getAutoRetryState() != 32L && autoRetryStatus.getAutoRetryState() != 33L) {
                return;
            }
            autoRetryStatus.setNextRestartScheduled(this.getNextRestartScheduledFor(autoRetryStatus.getTimeout()));
            this.autoRetryManager.setAutoRetryStatus(autoRetryStatus);
            Thread.sleep((long)autoRetryStatus.getTimeout() * 1000L);
            this.planExecutionManager.start(chain, buildDetectionAction, AcquisitionPolicy.IMMEDIATE);
            if (autoRetryStatus.getAutoRetryState() == 32L) {
                autoRetryStatus.setAutoRetryState(48L);
                autoRetryStatus.incrementRetryCount();
            } else if (autoRetryStatus.getAutoRetryState() == 33L) {
                autoRetryStatus.setAutoRetryState(49L);
            } else {
                throw new Exception("Auto Retry status is in an unexpected state");
            }
            this.autoRetryManager.setAutoRetryStatus(autoRetryStatus);
        }
        catch (Exception exp) {
            autoRetryStatus.setAutoRetryState(2306L);
            this.autoRetryManager.setAutoRetryStatus(autoRetryStatus);
            log.error((Object)String.format("Auto Retry experienced an error when scheduling the next retry of %s", autoRetryStatus.getPlanResultKey()), (Throwable)exp);
        }
    }

    private BuildDetectionAction getBuildDetectionAction(final ImmutableChain chain, final ChainResultsSummary crs, final ChainExecution ce, final PlanExecutionConfig planExecutionConfig) {
        return new AutoRetryBuildDetectionAction(){

            public Pair<Boolean, ErrorCollection> testIfBuildShouldStart(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull PlanExecutionLaunchControl.ReleaseLocksActions releaseLocksActions) {
                SimpleErrorCollection errors = new SimpleErrorCollection();
                return Pair.pair((Object)true, (Object)errors);
            }

            public BuildDetectionResult createBuildContext() {
                HashMap<String, String> variables = new HashMap<String, String>();
                for (VariableDefinition variable : crs.getImmutablePlan().getVariables()) {
                    if (!variable.getVariableType().equals((Object)VariableType.CUSTOM)) continue;
                    variables.put(variable.getKey(), variable.getValue());
                }
                PlanTriggerResult result = PlanTriggerResultBuilder.create(variables).addBuildChanges(ce.getBuildChanges()).build();
                VariableContext variableContext = UBPostChainAction.this.variableDefinitionManager.createVariableContextBuilder().addManualVariables(result.getVariableMap()).buildContext();
                BuildContextBuilder buildContextBuilder = UBPostChainAction.this.buildContextBuilderFactory.createBuilder();
                BuildContext buildContext = buildContextBuilder.plan((ImmutablePlan)chain).triggerReason(crs.getTriggerReason()).buildNumber(crs.getBuildNumber()).buildDefinition(chain.getBuildDefinition()).buildChanges(result.getBuildChanges()).variableContext(variableContext).artifactContext(UBPostChainAction.this.getArtifactContext()).build();
                return new BuildDetectionResultImpl(result.getErrorCollection(), buildContext);
            }

            public PlanExecutionConfig getPlanExecutionConfig() {
                return planExecutionConfig;
            }
        };
    }

    private ArtifactContext getArtifactContext() {
        try {
            SecureTokenService secureTokenService = this.secureTokenService != null ? this.secureTokenService : (SecureTokenService)this.applicationContext.getAutowireCapableBeanFactory().createBean(SecureTokenServiceImpl.class);
            return (ArtifactContextImpl)ArtifactContextImpl.class.getConstructors()[0].newInstance(secureTokenService.generate((Key)new BuildKey()), Collections.emptySet(), Collections.emptySet(), Optional.empty(), Collections.emptyMap());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)"Failed to create BuildContext: cannot instantiate ArtifactContext");
            return null;
        }
    }

    @NotNull
    private BranchIntegrationService getBranchIntegrationService() throws Exception {
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)this.cachedPlanManager);
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)this.repositoryDefinitionManager);
        return (BranchIntegrationService)this.applicationContext.getAutowireCapableBeanFactory().createBean(BranchIntegrationServiceImpl.class);
    }

    private long getNextRestartScheduledFor(int timeout) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, timeout);
        return calendar.getTimeInMillis();
    }
}

