/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.autoretry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.collabsoft.plugins.bamboo.api.v1.entities.AutoRetryConfig;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class AutoRetryStatus {
    private int id;
    private String projectKey;
    private String planKey;
    private String planResultKey;
    private int retries;
    private int timeout;
    private boolean rerun;
    private long autoRetryState;
    private int numberOfRetries;
    private Long nextRestartScheduled;
    private boolean failed;
    private boolean restartable;
    private boolean stopRequested;

    public AutoRetryStatus(AutoRetryConfig autoRetryConfig) {
        this.id = autoRetryConfig.getID();
        this.projectKey = autoRetryConfig.getProjectKey();
        this.planKey = autoRetryConfig.getPlanKey();
        this.timeout = autoRetryConfig.getTimeout();
        this.retries = autoRetryConfig.getRetries();
        this.rerun = autoRetryConfig.isRerun();
    }

    public void merge(AutoRetryStatus autoRetryStatus) {
        this.planResultKey = autoRetryStatus.getPlanResultKey();
        this.autoRetryState = autoRetryStatus.getAutoRetryState();
        this.numberOfRetries = autoRetryStatus.getNumberOfRetries();
        this.nextRestartScheduled = autoRetryStatus.getNextRestartScheduled();
        this.failed = autoRetryStatus.isFailed();
        this.restartable = autoRetryStatus.isRestartable();
        this.stopRequested = autoRetryStatus.isStopRequested();
    }

    public String toString() {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)this);
    }

    public void incrementRetryCount() {
        ++this.numberOfRetries;
    }

    public int getId() {
        return this.id;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getPlanKey() {
        return this.planKey;
    }

    public String getPlanResultKey() {
        return this.planResultKey;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public long getAutoRetryState() {
        return this.autoRetryState;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public Long getNextRestartScheduled() {
        return this.nextRestartScheduled;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public void setPlanKey(String planKey) {
        this.planKey = planKey;
    }

    public void setPlanResultKey(String planResultKey) {
        this.planResultKey = planResultKey;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setRerun(boolean rerun) {
        this.rerun = rerun;
    }

    public void setAutoRetryState(long autoRetryState) {
        this.autoRetryState = autoRetryState;
    }

    public void setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }

    public void setNextRestartScheduled(Long nextRestartScheduled) {
        this.nextRestartScheduled = nextRestartScheduled;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public void setStopRequested(boolean stopRequested) {
        this.stopRequested = stopRequested;
    }
}

