/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.autoretry;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import net.collabsoft.plugins.bamboo.api.v1.entities.AutoRetryConfig;
import net.collabsoft.plugins.bamboo.api.v1.repositories.AutoRetryDAO;
import net.collabsoft.plugins.bamboo.autoretry.AutoRetryStatus;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class AutoRetryManager {
    public static final long IS_ELIGIBLE_FOR_RETRY = 0L;
    public static final long IS_ELIGIBLE_FOR_RERUN = 1L;
    public static final long IS_AWAITING_RETRY = 32L;
    public static final long IS_AWAITING_RERUN = 33L;
    public static final long IS_RETRYING = 48L;
    public static final long IS_RERUNNING = 49L;
    public static final long IS_FIXED_BY_RETRY = 80L;
    public static final long IS_FIXED_BY_RERUN = 81L;
    public static final long IS_PERSISTENT_FAILURE_RETRY = 144L;
    public static final long IS_PERSISTENT_FAILURE_RERUN = 145L;
    public static final long LICENSE_INVALID = 256L;
    public static final long CANNOT_BE_RESTARTED = 272L;
    public static final long STOP_REQUESTED = 288L;
    public static final long ALREADY_EXECUTING = 304L;
    public static final long SUSPENDED = 320L;
    public static final long MARKED_FOR_DELETION = 336L;
    public static final long NO_RETRY_CONFIGURATION = 352L;
    public static final long STATE_ERROR = 2306L;
    public static final String AUTO_RETRY_STATUS_KEY = "net.collabsoft.plugins.bamboo.autoretry.AutoRetryStatus";
    private final AutoRetryDAO autoRetryDAO;
    private final ProjectManager projectManager;
    private final PlanManager planManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final PluginLicenseManager licenseManager;
    private final PluginRetrievalService pluginRetrievalService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    AutoRetryManager(AutoRetryDAO autoRetryDAO, @BambooImport ProjectManager projectManager, @BambooImport PlanManager planManager, @BambooImport ResultsSummaryManager resultsSummaryManager, @BambooImport PluginLicenseManager licenseManager, @BambooImport PluginRetrievalService pluginRetrievalService, @BambooImport TransactionTemplate transactionTemplate) {
        this.autoRetryDAO = autoRetryDAO;
        this.projectManager = projectManager;
        this.planManager = planManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.licenseManager = licenseManager;
        this.pluginRetrievalService = pluginRetrievalService;
        this.transactionTemplate = transactionTemplate;
    }

    public long getAutoRetryState(ImmutableChain chain, AutoRetryStatus autoRetryStatus) {
        PlanKey planKey = chain.getPlanKey();
        Project project = chain.getProject();
        AutoRetryConfig config = this.autoRetryDAO.get(project.getKey(), planKey.getKey());
        if (config == null) {
            return 352L;
        }
        if (!this.isLicenseValid()) {
            return 256L;
        }
        if (!autoRetryStatus.isRestartable()) {
            return 272L;
        }
        if (autoRetryStatus.isStopRequested()) {
            return 288L;
        }
        if (chain.isExecuting()) {
            return 304L;
        }
        if (chain.isSuspended() || chain.isSuspendedFromBuilding()) {
            return 320L;
        }
        if (chain.isMarkedForDeletion()) {
            return 336L;
        }
        if (this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((String)autoRetryStatus.getPlanResultKey())) == null) {
            return 336L;
        }
        if (this.planManager.getPlanByKey(chain.getPlanKey()) == null) {
            return 336L;
        }
        if (!this.projectManager.isExistingProjectKey(chain.getProject().getKey())) {
            return 336L;
        }
        int retries = autoRetryStatus.getNumberOfRetries();
        int maxRetries = autoRetryStatus.getRetries();
        if (!autoRetryStatus.isFailed()) {
            if (retries <= maxRetries) {
                return 80L;
            }
            return 81L;
        }
        if (retries == maxRetries) {
            if (autoRetryStatus.isRerun()) {
                if (autoRetryStatus.getAutoRetryState() == 49L) {
                    return 145L;
                }
                return 1L;
            }
            return 144L;
        }
        if (retries > maxRetries) {
            return 145L;
        }
        return 0L;
    }

    public AutoRetryStatus getAutoRetryStatusFor(String planResultKey) {
        ChainResultsSummary crs;
        PlanResultKey key = this.toPlanResultKey(planResultKey);
        if (key != null && (crs = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(key, ChainResultsSummary.class, ResultDataRead.EAGER)) != null) {
            return this.getAutoRetryStatusFor(crs);
        }
        return null;
    }

    public AutoRetryStatus getAutoRetryStatusFor(ChainResultsSummary chainResultsSummary) {
        AutoRetryConfig autoRetryConfig = this.getAutoRetryConfigFor(chainResultsSummary);
        if (autoRetryConfig == null) {
            return null;
        }
        AutoRetryStatus result = new AutoRetryStatus(autoRetryConfig);
        if (chainResultsSummary.getCustomBuildData().containsKey(AUTO_RETRY_STATUS_KEY)) {
            String json;
            Gson gson = new GsonBuilder().create();
            AutoRetryStatus autoRetryStatus = (AutoRetryStatus)gson.fromJson(json = (String)Narrow.to(chainResultsSummary.getCustomBuildData().get(AUTO_RETRY_STATUS_KEY), String.class), AutoRetryStatus.class);
            if (autoRetryStatus.getId() != result.getId()) {
                return null;
            }
            result.merge(autoRetryStatus);
        } else {
            result.setPlanResultKey(chainResultsSummary.getPlanResultKey().getKey());
            result.setFailed(chainResultsSummary.isFailed());
            result.setNumberOfRetries(0);
            result.setRestartable(chainResultsSummary.isRestartable());
            result.setStopRequested(false);
        }
        return result;
    }

    public void setAutoRetryStatus(AutoRetryStatus autoRetryStatus) {
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)autoRetryStatus.getPlanResultKey());
        this.setAutoRetryStatus(planResultKey, autoRetryStatus);
    }

    void setAutoRetryStatus(PlanResultKey planResultKey, AutoRetryStatus autoRetryStatus) {
        ChainResultsSummary resultsSummary = (ChainResultsSummary)this.transactionTemplate.execute(() -> (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey, ChainResultsSummary.class));
        if (resultsSummary != null) {
            this.setAutoRetryStatus(resultsSummary, autoRetryStatus);
        }
    }

    public void setAutoRetryStatus(ChainResultsSummary crs, AutoRetryStatus autoRetryStatus) {
        this.setAutoRetryStatus((ResultsSummary)crs, autoRetryStatus);
    }

    void setAutoRetryStatus(ResultsSummary resultsSummary, AutoRetryStatus autoRetryStatus) {
        this.transactionTemplate.execute(() -> {
            Map customBuildData = resultsSummary.getCustomBuildData();
            customBuildData.put(AUTO_RETRY_STATUS_KEY, autoRetryStatus.toString());
            resultsSummary.getCustomBuildData().put(AUTO_RETRY_STATUS_KEY, autoRetryStatus.toString());
            this.resultsSummaryManager.saveResultSummary(resultsSummary);
            return null;
        });
    }

    private AutoRetryConfig getAutoRetryConfigFor(ChainResultsSummary chainResultsSummary) {
        ImmutableChain plan = chainResultsSummary.getImmutablePlan();
        ImmutableChain chain = chainResultsSummary.getImmutablePlan();
        Project project = chain.getProject();
        return this.autoRetryDAO.get(project.getKey(), plan.getPlanKey().getKey());
    }

    private boolean isLicenseValid() {
        if (!this.isLicenseEnabled()) {
            return true;
        }
        return this.licenseManager.getLicense().isDefined() && ((PluginLicense)this.licenseManager.getLicense().get()).isValid();
    }

    private boolean isLicenseEnabled() {
        Plugin plugin = this.pluginRetrievalService.getPlugin();
        Map params = plugin.getPluginInformation().getParameters();
        return Boolean.parseBoolean(params.getOrDefault("atlassian-licensing-enabled", "false"));
    }

    private PlanResultKey toPlanResultKey(String planResultKey) {
        try {
            return PlanKeys.getPlanResultKey((String)planResultKey);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }
}

