/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.api.v1.services;

import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionFactory;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import java.util.List;
import java.util.stream.Collectors;
import net.collabsoft.plugins.bamboo.api.v1.dto.ProjectVariableDTO;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class ProjectVariablesService {
    private final VariableDefinitionManager variableDefinitionManager;
    private final VariableDefinitionFactory variableDefinitionFactory;

    @Autowired
    ProjectVariablesService(@BambooImport VariableDefinitionManager variableDefinitionManager, @BambooImport VariableDefinitionFactory variableDefinitionFactory) {
        this.variableDefinitionManager = variableDefinitionManager;
        this.variableDefinitionFactory = variableDefinitionFactory;
    }

    public VariableDefinition createVariableDefinition(ProjectVariableDTO projectVariable) {
        String variableKey = projectVariable.getProjectKey() + "." + projectVariable.getKey();
        VariableDefinition globalVariable = this.variableDefinitionFactory.createGlobalVariable(variableKey, projectVariable.getValue());
        this.variableDefinitionManager.saveVariableDefinition(globalVariable);
        return globalVariable;
    }

    public VariableDefinition updateVariable(ProjectVariableDTO projectVariable) {
        VariableDefinition globalVariable = this.findById(projectVariable.getId());
        if (globalVariable != null) {
            globalVariable.setKey(projectVariable.getProjectKey() + "." + projectVariable.getKey());
            globalVariable.setValue(projectVariable.getValue());
            this.variableDefinitionManager.saveVariableDefinition(globalVariable);
            return globalVariable;
        }
        return null;
    }

    public VariableDefinition findById(long id) {
        return this.variableDefinitionManager.findVariableDefinition(id);
    }

    public List<VariableDefinition> findAllByProjectKey(String projectKey) {
        return this.variableDefinitionManager.getGlobalVariables().stream().filter(variable -> variable.getKey().startsWith(projectKey + ".")).collect(Collectors.toList());
    }

    public boolean deleteById(long id) {
        VariableDefinition globalVariable = this.findById(id);
        if (globalVariable != null) {
            this.variableDefinitionManager.deleteVariableDefinition(globalVariable);
            return true;
        }
        return false;
    }
}

