/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.api.v1.services;

import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.collabsoft.plugins.bamboo.api.v1.entities.EnrichedDashboardItem;
import net.collabsoft.plugins.bamboo.api.v1.repositories.EnrichedDashboardDAO;
import net.collabsoft.plugins.bamboo.api.v1.services.ProjectVariablesService;
import net.collabsoft.plugins.bamboo.api.v1.services.Service;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class EnrichedDashboardService
implements Service<EnrichedDashboardItem> {
    private final EnrichedDashboardDAO repository;
    private final ProjectVariablesService projectVariablesService;
    private final VariableDefinitionManager variableDefinitionManager;

    @Autowired
    EnrichedDashboardService(EnrichedDashboardDAO dao, ProjectVariablesService projectVariablesService, @BambooImport VariableDefinitionManager variableDefinitionManager) {
        this.repository = dao;
        this.projectVariablesService = projectVariablesService;
        this.variableDefinitionManager = variableDefinitionManager;
    }

    @Override
    public EnrichedDashboardItem getOrCreate(int id) {
        return this.repository.getOrCreate(id);
    }

    @Override
    public EnrichedDashboardItem findById(int id) {
        return this.repository.get(id);
    }

    @Override
    public List<EnrichedDashboardItem> findAllByProjectKey(String projectKey) {
        return this.findAllByProjectKey(projectKey, true);
    }

    public List<EnrichedDashboardItem> findAllByProjectKey(String projectKey, boolean replaceVariables) {
        List globalVariables = this.variableDefinitionManager.getGlobalVariables();
        List<VariableDefinition> projectVariables = this.projectVariablesService.findAllByProjectKey(projectKey);
        EnrichedDashboardItem[] items = this.repository.get(projectKey);
        Stream<EnrichedDashboardItem> result = Arrays.stream(items);
        if (replaceVariables) {
            result = result.peek(item -> {
                globalVariables.forEach(globalVariable -> {
                    item.setName(this.doReplace(item.getName(), (VariableDefinition)globalVariable));
                    item.setValue(this.doReplace(item.getValue(), (VariableDefinition)globalVariable));
                });
                projectVariables.stream().peek(projectVariable -> {
                    if (projectVariable.getKey().startsWith(projectKey)) {
                        projectVariable.setKey(projectVariable.getKey().substring(projectKey.length() + 1));
                    }
                }).forEach(projectVariable -> {
                    item.setName(this.doReplace(item.getName(), (VariableDefinition)projectVariable));
                    item.setValue(this.doReplace(item.getValue(), (VariableDefinition)projectVariable));
                });
                globalVariables.forEach(globalVariable -> {
                    item.setName(this.doReplace(item.getName(), (VariableDefinition)globalVariable));
                    item.setValue(this.doReplace(item.getValue(), (VariableDefinition)globalVariable));
                });
            });
        }
        return result.collect(Collectors.toList());
    }

    @Override
    public void deleteById(int id) {
        this.repository.delete(id);
    }

    private String doReplace(String value, VariableDefinition projectVariable) {
        String replacement = projectVariable.getValue();
        if (replacement != null && value.contains("${bamboo." + projectVariable.getKey() + "}")) {
            value = value.replace("${bamboo." + projectVariable.getKey() + "}", replacement);
            return this.doReplace(value, projectVariable);
        }
        return value;
    }
}

