/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.api.v1.controllers;

import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.collabsoft.plugins.bamboo.api.v1.controllers.AbstractController;
import net.collabsoft.plugins.bamboo.api.v1.dto.ProjectVariableDTO;
import net.collabsoft.plugins.bamboo.api.v1.services.ProjectVariablesService;

@Path(value="/projectvariables")
public class ProjectVariablesController
extends AbstractController {
    private final ProjectVariablesService projectVariablesService;

    ProjectVariablesController(ProjectVariablesService projectVariablesService, @BambooImport ProjectManager projectManager, @BambooImport BambooPermissionManager bambooPermissionManager) {
        super(projectManager, bambooPermissionManager);
        this.projectVariablesService = projectVariablesService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/list")
    public Response list(@QueryParam(value="projectKey") String projectKey) {
        if (!this.hasProjectAdministrationRights(projectKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List result = this.projectVariablesService.findAllByProjectKey(projectKey).stream().map(variable -> new ProjectVariableDTO((VariableDefinition)variable, projectKey)).collect(Collectors.toList());
        return Response.ok(result).build();
    }

    @PUT
    @Path(value="/list")
    public Response create(ProjectVariableDTO projectVariable) {
        if (projectVariable.getId() != null && projectVariable.getId() > 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.hasProjectAdministrationRights(projectVariable.getProjectKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        VariableDefinition globalVariable = this.projectVariablesService.createVariableDefinition(projectVariable);
        ProjectVariableDTO dto = new ProjectVariableDTO(globalVariable, projectVariable.getProjectKey());
        return Response.ok((Object)dto).build();
    }

    @PUT
    @Path(value="/{id}")
    public Response update(ProjectVariableDTO projectVariable) {
        VariableDefinition globalVariable = this.projectVariablesService.updateVariable(projectVariable);
        if (globalVariable == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.hasProjectAdministrationRights(projectVariable.getProjectKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)new ProjectVariableDTO(globalVariable, projectVariable.getProjectKey())).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(ProjectVariableDTO projectVariable) {
        if (!this.hasProjectAdministrationRights(projectVariable.getProjectKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        boolean success = this.projectVariablesService.deleteById(projectVariable.getId());
        Response.ResponseBuilder response = success ? Response.noContent() : Response.status((Response.Status)Response.Status.NOT_FOUND);
        return response.build();
    }
}

