/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo.api.v1.controllers;

import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.collabsoft.plugins.bamboo.api.v1.controllers.AbstractController;
import net.collabsoft.plugins.bamboo.api.v1.dto.EnrichedDashboardItemDTO;
import net.collabsoft.plugins.bamboo.api.v1.entities.EnrichedDashboardItem;
import net.collabsoft.plugins.bamboo.api.v1.services.EnrichedDashboardService;

@Path(value="/enricheddashboard")
public class EnrichedDashboardController
extends AbstractController<EnrichedDashboardItem> {
    EnrichedDashboardController(EnrichedDashboardService enrichedDashboardService, @BambooImport ProjectManager projectManager, @BambooImport BambooPermissionManager bambooPermissionManager) {
        super(enrichedDashboardService, projectManager, bambooPermissionManager);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/list")
    public Response list(@QueryParam(value="projectKey") String key, @QueryParam(value="forDashboard") boolean forDashboard) {
        String projectKey = this.toProjectKey(key);
        if (!this.hasProjectAdministrationRights(projectKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List result = ((EnrichedDashboardService)this.service).findAllByProjectKey(projectKey, forDashboard).stream().map(EnrichedDashboardItemDTO::new).collect(Collectors.toList());
        return Response.ok(result).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/list")
    public Response create(EnrichedDashboardItemDTO item) {
        if (item.getId() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.hasProjectAdministrationRights(item.getProjectKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        EnrichedDashboardItem result = this.updateOrCreate(item);
        EnrichedDashboardItemDTO dto = new EnrichedDashboardItemDTO(result);
        return Response.ok((Object)dto).build();
    }

    @GET
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") int id) {
        EnrichedDashboardItemDTO result = new EnrichedDashboardItemDTO((EnrichedDashboardItem)this.service.findById(id));
        if (!this.hasProjectAdministrationRights(result.getProjectKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)result).build();
    }

    @PUT
    @Path(value="/{id}")
    public Response update(@PathParam(value="id") int id, EnrichedDashboardItemDTO item) {
        if (id != item.getId()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.hasProjectAdministrationRights(item.getProjectKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        EnrichedDashboardItem enrichedDashboardItem = (EnrichedDashboardItem)this.service.findById(id);
        if (enrichedDashboardItem == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        enrichedDashboardItem = this.updateOrCreate(item);
        EnrichedDashboardItemDTO dto = new EnrichedDashboardItemDTO(enrichedDashboardItem);
        return Response.ok((Object)dto).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") int id) {
        return this.deleteById(id);
    }

    private EnrichedDashboardItem updateOrCreate(EnrichedDashboardItemDTO item) {
        EnrichedDashboardItem enrichedDashboardItem = (EnrichedDashboardItem)this.service.getOrCreate(item.getId());
        enrichedDashboardItem.setProjectKey(item.getProjectKey());
        enrichedDashboardItem.setName(item.getName());
        enrichedDashboardItem.setValue(item.getValue());
        enrichedDashboardItem.save();
        return enrichedDashboardItem;
    }
}

