/*
 * Decompiled with CFR 0.152.
 */
package net.collabsoft.plugins.bamboo;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.SimpleLogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.buildqueue.manager.CustomPreBuildQueuedAction;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.util.Map;
import org.apache.log4j.Logger;

public class UBPreBuildQueuedAction
implements CustomPreBuildQueuedAction {
    private static final Logger log = Logger.getLogger(UBPreBuildQueuedAction.class);
    private final PluginLicenseManager licenseManager;
    private final PluginRetrievalService pluginRetrievalService;
    private final BuildLoggerManager buildLoggerManager;
    private BuildContext buildContext;

    public UBPreBuildQueuedAction(@BambooImport PluginLicenseManager licenseManager, @BambooImport PluginRetrievalService pluginRetrievalService, @BambooImport BuildLoggerManager buildLoggerManager) {
        this.licenseManager = licenseManager;
        this.pluginRetrievalService = pluginRetrievalService;
        this.buildLoggerManager = buildLoggerManager;
    }

    public void init(BuildContext bc) {
        this.buildContext = bc;
    }

    public BuildContext call() {
        if (!this.isLicenseValid()) {
            this.buildContext.getBuildResult().setBuildState(BuildState.FAILED);
            BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)this.buildContext.getPlanResultKey());
            SimpleLogEntry logMessage = new SimpleLogEntry("Utility Belt for Bamboo license is missing or invalid");
            buildLogger.addErrorLogEntry((LogEntry)logMessage);
            this.buildContext.getErrorCollection().addErrorMessage("Utility Belt for Bamboo license is missing or invalid");
            log.error((Object)"Utility Belt for Bamboo license is missing or invalid");
        }
        return this.buildContext;
    }

    private boolean isLicenseValid() {
        if (!this.isLicenseEnabled()) {
            return true;
        }
        return this.licenseManager.getLicense().isDefined() && ((PluginLicense)this.licenseManager.getLicense().get()).isValid();
    }

    private boolean isLicenseEnabled() {
        Plugin plugin = this.pluginRetrievalService.getPlugin();
        Map params = plugin.getPluginInformation().getParameters();
        return Boolean.parseBoolean((String)params.get("atlassian-licensing-enabled"));
    }
}

