/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jmeter_aggregator.web;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.ViewBuild;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.jmeter_aggregator.ReportGroup;
import com.atlassian.bamboo.plugins.jmeter_aggregator.builder.JmeterBuildDataHelper;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ReportGroups
extends ViewBuild {
    private BandanaManager bandanaManager;
    private static final String BUILD_GROUPS_BANDANA_KEY = "bamboo.jmeter.aggregator.build.groups";
    private Map<String, Collection<String>> rawReportGroups;
    private Collection<ReportGroup> reportGroups;
    private ReportGroup reportGroup;
    private Collection<String> availableSamplers;
    private String reportGroupName;
    private Collection<String> samplersToAdd;
    private Collection<String> samplersToRemove;
    private String customSamplersToAdd;

    public String view() {
        return "success";
    }

    public String get() {
        if (this.getReportGroup() == null) {
            return "input";
        }
        return "success";
    }

    public String delete() {
        Map<String, Collection<String>> groups = this.getRawReportGroups();
        groups.remove(this.getReportGroupName());
        this.saveRawReportGroups(groups);
        return "success";
    }

    public String create() {
        Map<String, Collection<String>> groups = this.getRawReportGroups();
        if (StringUtils.isBlank((String)this.getReportGroupName())) {
            this.addActionError("Report group name must not be blank");
            return "input";
        }
        if (groups.containsKey(this.getReportGroupName())) {
            this.addActionError("Report group with that name already exists");
            return "input";
        }
        if (this.getAvailableSamplers().contains(this.getReportGroupName())) {
            this.addActionError("A sampler with that name already exists");
            return "input";
        }
        groups.put(this.getReportGroupName(), Sets.newTreeSet());
        this.saveRawReportGroups(groups);
        return "success";
    }

    public String add() {
        Map<String, Collection<String>> groups = this.getRawReportGroups();
        Collection<String> samplers = groups.get(this.getReportGroupName());
        samplers.addAll(this.samplersToAdd);
        if (StringUtils.isNotBlank((String)this.customSamplersToAdd)) {
            String[] customSamplers;
            for (String sampler : customSamplers = this.customSamplersToAdd.split("(?m)$")) {
                if ((sampler = sampler.trim()).length() <= 0) continue;
                samplers.add(sampler);
            }
        }
        this.saveRawReportGroups(groups);
        return "success";
    }

    public String remove() {
        Map<String, Collection<String>> groups = this.getRawReportGroups();
        Collection<String> samplers = groups.get(this.getReportGroupName());
        samplers.removeAll(this.samplersToRemove);
        this.saveRawReportGroups(groups);
        return "success";
    }

    public Collection<ReportGroup> getReportGroups() {
        if (this.reportGroups == null) {
            this.reportGroups = Lists.newArrayList();
            for (Map.Entry<String, Collection<String>> entry : this.getRawReportGroups().entrySet()) {
                this.reportGroups.add(new ReportGroup(entry.getKey(), entry.getValue()));
            }
            Collections.sort((List)this.reportGroups);
        }
        return this.reportGroups;
    }

    public ReportGroup getReportGroup() {
        if (this.reportGroup == null) {
            Collection<String> samplers = this.getRawReportGroups().get(this.getReportGroupName());
            if (samplers == null) {
                return null;
            }
            this.reportGroup = new ReportGroup(this.reportGroupName, samplers);
        }
        return this.reportGroup;
    }

    public Collection<String> getAvailableSamplers() {
        if (this.availableSamplers == null) {
            ResultsSummary summary = this.getMutableBuild().getLatestResultsSummary();
            this.availableSamplers = summary != null ? Ordering.natural().sortedCopy(Iterables.filter(JmeterBuildDataHelper.getSamplerMapFromCustomData(summary.getCustomBuildData()).keySet(), (Predicate)Predicates.and((Predicate)Predicates.notNull(), (Predicate)Predicates.not((Predicate)Predicates.in(this.getReportGroup().getSamplers()))))) : Collections.emptyList();
        }
        return this.availableSamplers;
    }

    private void saveRawReportGroups(Map<String, Collection<String>> groups) {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.forPlan((ImmutablePlan)this.getImmutableBuild()), BUILD_GROUPS_BANDANA_KEY, groups);
        this.reportGroups = null;
        this.reportGroup = null;
        this.availableSamplers = null;
    }

    private Map<String, Collection<String>> getRawReportGroups() {
        if (this.rawReportGroups == null) {
            this.rawReportGroups = (Map)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.forPlan((ImmutablePlan)this.getImmutableBuild()), BUILD_GROUPS_BANDANA_KEY);
            if (this.rawReportGroups == null) {
                this.rawReportGroups = Maps.newHashMap();
            }
        }
        return this.rawReportGroups;
    }

    public void setReportGroupName(String reportGroupName) {
        this.reportGroupName = reportGroupName;
    }

    public Collection<String> getSamplersToAdd() {
        return this.samplersToAdd;
    }

    public void setSamplersToAdd(Collection<String> samplersToAdd) {
        this.samplersToAdd = samplersToAdd;
    }

    public Collection<String> getSamplersToRemove() {
        return this.samplersToRemove;
    }

    public void setSamplersToRemove(Collection<String> samplersToRemove) {
        this.samplersToRemove = samplersToRemove;
    }

    public String getCustomSamplersToAdd() {
        return this.customSamplersToAdd;
    }

    public void setCustomSamplersToAdd(String customSamplersToAdd) {
        this.customSamplersToAdd = customSamplersToAdd;
    }

    public String getReportGroupName() {
        return this.reportGroupName;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }
}

