/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jmeter_aggregator.web;

import com.atlassian.bamboo.build.ViewBuild;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugins.jmeter_aggregator.Sampler;
import com.atlassian.bamboo.plugins.jmeter_aggregator.builder.JmeterBuildDataHelper;
import com.atlassian.bamboo.plugins.jmeter_aggregator.builder.SamplerSeries;
import com.atlassian.bamboo.plugins.jmeter_aggregator.web.SamplerMetric;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.core.util.RandomGenerator;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class AggregationReport
extends ViewBuild {
    private static final Logger log = Logger.getLogger(AggregationReport.class);
    private List<String> samplers;
    private List<String> metrics;
    private boolean includeTotal;
    private Collection<String> availableSamplers;
    private Map<String, Object> chart;

    public String select() throws Exception {
        return "success";
    }

    public String view() throws Exception {
        return "success";
    }

    public String generate() {
        if (!this.includeTotal && (this.samplers == null || this.samplers.isEmpty())) {
            this.addActionError("You must select at least one sampler");
            return "success";
        }
        if (this.metrics == null || this.metrics.isEmpty()) {
            this.addActionError("You must select at least one metric");
            return "success";
        }
        ArrayList summaries = Lists.newArrayList((Iterable)this.getResultsList());
        Map<SamplerSeries, List<Number[]>> series = this.getSeriesMap();
        Map<SamplerSeries, List<Number[]>> totalSeries = this.getTotalSeriesMap();
        this.extractDataIntoMaps(summaries, series, totalSeries);
        XYSeriesCollection dataset = this.convertMapToXySeries(series, totalSeries);
        this.createChart(dataset);
        return "success";
    }

    private void createChart(XYSeriesCollection dataset) {
        this.chart = Maps.newHashMap();
        ChartRenderingInfo chartRenderingInfo = this.newChartRenderingInfo();
        JFreeChart jchart = ChartFactory.createXYLineChart((String)"", (String)"Build Number", (String)"Values", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)jchart.getPlot();
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        try {
            String location = this.getSavedChartLocation(chartRenderingInfo, jchart);
            this.chart.put("location", location);
            this.chart.put("width", 600);
            this.chart.put("height", 500);
            String mapName = this.generateRandomString() + "_map";
            this.chart.put("imageMap", this.getImageMap(chartRenderingInfo, mapName));
            this.chart.put("imageMapName", mapName);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    protected String getImageMap(ChartRenderingInfo chartRenderingInfo, String mapName) {
        return ChartUtilities.getImageMap((String)mapName, (ChartRenderingInfo)chartRenderingInfo);
    }

    protected String generateRandomString() {
        return RandomGenerator.randomString((int)5);
    }

    protected ChartRenderingInfo newChartRenderingInfo() {
        return new ChartRenderingInfo();
    }

    protected String getSavedChartLocation(ChartRenderingInfo chartRenderingInfo, JFreeChart jchart) throws IOException {
        return ServletUtilities.saveChartAsPNG((JFreeChart)jchart, (int)600, (int)500, (ChartRenderingInfo)chartRenderingInfo, null);
    }

    private XYSeriesCollection convertMapToXySeries(Map<SamplerSeries, List<Number[]>> series, Map<SamplerSeries, List<Number[]>> totalSeries) {
        XYSeries s;
        List<Number[]> data;
        SamplerSeries samplerSeries;
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (Map.Entry<SamplerSeries, List<Number[]>> entry : series.entrySet()) {
            samplerSeries = entry.getKey();
            data = entry.getValue();
            if (data.isEmpty()) continue;
            s = new XYSeries((Comparable)((Object)(samplerSeries.getLabel() + " - " + samplerSeries.getMetric().getDescription())));
            for (Number[] values : data) {
                s.add(values[0], values[1]);
            }
            dataset.addSeries(s);
        }
        if (this.includeTotal) {
            for (Map.Entry<SamplerSeries, List<Number[]>> entry : totalSeries.entrySet()) {
                samplerSeries = entry.getKey();
                data = entry.getValue();
                if (data.isEmpty()) continue;
                s = new XYSeries((Comparable)((Object)(samplerSeries.getLabel() + " - " + samplerSeries.getMetric().getDescription())));
                for (Number[] values : data) {
                    s.add(values[0], values[1]);
                }
                dataset.addSeries(s);
            }
        }
        return dataset;
    }

    private void extractDataIntoMaps(List<ResultsSummary> summaries, Map<SamplerSeries, List<Number[]>> series, Map<SamplerSeries, List<Number[]>> totalSeries) {
        for (ResultsSummary summary : summaries) {
            Sampler totalSampler;
            Map<String, Sampler> samplerMap = JmeterBuildDataHelper.getSamplerMapFromCustomData(summary.getCustomBuildData());
            for (Map.Entry<SamplerSeries, List<Number[]>> entry : series.entrySet()) {
                SamplerSeries samplerSeries = entry.getKey();
                Sampler sampler = samplerMap.get(samplerSeries.getLabel());
                if (sampler == null) continue;
                entry.getValue().add(new Number[]{summary.getBuildNumber(), samplerSeries.getMetric().getScaledValueFromSampler(sampler)});
            }
            if (!this.includeTotal || (totalSampler = JmeterBuildDataHelper.getTotalSamplerFromCustomData(summary.getCustomBuildData())) == null) continue;
            for (Map.Entry<SamplerSeries, List<Number[]>> entry : totalSeries.entrySet()) {
                SamplerSeries samplerSeries = entry.getKey();
                entry.getValue().add(new Number[]{summary.getBuildNumber(), samplerSeries.getMetric().getScaledValueFromSampler(totalSampler)});
            }
        }
    }

    private Map<SamplerSeries, List<Number[]>> getTotalSeriesMap() {
        HashMap totalSeries = Maps.newHashMap();
        if (this.includeTotal) {
            for (String metric : this.metrics) {
                SamplerMetric sm = SamplerMetric.valueOf(metric);
                if (sm == null) continue;
                SamplerSeries ss = new SamplerSeries("Total", sm);
                totalSeries.put(ss, Lists.newArrayList());
            }
        }
        return totalSeries;
    }

    private Map<SamplerSeries, List<Number[]>> getSeriesMap() {
        HashMap series = Maps.newHashMap();
        if (this.samplers != null) {
            for (String sampler : this.samplers) {
                for (String metric : this.metrics) {
                    SamplerMetric sm = SamplerMetric.valueOf(metric);
                    if (sm == null) continue;
                    SamplerSeries ss = new SamplerSeries(sampler, sm);
                    series.put(ss, Lists.newArrayList());
                }
            }
        }
        return series;
    }

    public Map<String, Object> getChart() {
        return this.chart;
    }

    public int getNumberOfProjects() {
        return this.projectManager.getAllProjects().size();
    }

    public Collection<String> getAvailableSamplers() {
        if (this.availableSamplers == null) {
            ResultsSummary summary = this.getMutableBuild().getLatestResultsSummary();
            this.availableSamplers = summary != null ? Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).sortedCopy(Iterables.filter(JmeterBuildDataHelper.getSamplerMapFromCustomData(summary.getCustomBuildData()).keySet(), (Predicate)Predicates.notNull())) : Collections.emptyList();
        }
        return this.availableSamplers;
    }

    public Map<String, String> getAvailableMetrics() {
        TreeMap metrics = Maps.newTreeMap();
        for (SamplerMetric metric : SamplerMetric.values()) {
            metrics.put(metric.name(), metric.getDescription());
        }
        return metrics;
    }

    public String getBuildNameFromKey(String key) {
        ImmutablePlan plan;
        if (key != null && (plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)key))) != null) {
            return plan.getName();
        }
        return key;
    }

    public List<String> getSamplers() {
        return this.samplers;
    }

    public void setSamplers(List<String> samplers) {
        this.samplers = samplers;
    }

    public List<String> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<String> metrics) {
        this.metrics = metrics;
    }

    public boolean isIncludeTotal() {
        return this.includeTotal;
    }

    public void setIncludeTotal(boolean includeTotal) {
        this.includeTotal = includeTotal;
    }
}

