/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jmeter_aggregator.parser;

import com.atlassian.bamboo.plugins.jmeter_aggregator.Sampler;
import com.atlassian.bamboo.plugins.jmeter_aggregator.SamplerImpl;
import com.atlassian.bamboo.plugins.jmeter_aggregator.parser.SampleResultsParser;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.NotThreadSafe;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
public class JtlSaxHandler
extends DefaultHandler
implements SampleResultsParser {
    private static final Logger log = Logger.getLogger(JtlSaxHandler.class);
    private static final String JTL_VERSION = "1.2";
    private static final Pattern THREAD_GROUP_PATTERN = Pattern.compile("(.*?)\\s*\\d+-\\d+");
    private final Map<String, Sampler> samplerMap;
    private final SamplerImpl totalSampler;
    private final boolean aggregateThreadGroups;

    public JtlSaxHandler(boolean aggregateThreadGroups) {
        this.aggregateThreadGroups = aggregateThreadGroups;
        this.samplerMap = new HashMap<String, Sampler>();
        this.totalSampler = new SamplerImpl(null);
    }

    @Override
    public Map<String, Sampler> getSamplerMap() {
        return this.samplerMap;
    }

    @Override
    public SamplerImpl getTotalSampler() {
        return this.totalSampler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("testResults".equals(localName)) {
            String version = attributes.getValue("version");
            if (version == null) {
                log.warn((Object)"No version specified in JTL file");
            } else if (!version.equals(JTL_VERSION)) {
                log.warn((Object)("Parsing unknown JTL version: " + version));
            }
        } else if ("sample".equals(localName) || "httpSample".equals(localName)) {
            this.handleSample(attributes);
        }
    }

    private void handleSample(Attributes attributes) {
        SamplerImpl sampler;
        String label = attributes.getValue("lb");
        if (label == null || label.length() == 0) {
            label = "null";
        }
        if ((sampler = (SamplerImpl)this.samplerMap.get(label)) == null) {
            sampler = new SamplerImpl(label);
            this.samplerMap.put(label, sampler);
        }
        long sampleTime = this.getLongAttribute(attributes, "t");
        long startTime = this.getLongAttribute(attributes, "ts");
        boolean pass = this.getBooleanAttribute(attributes, "s");
        sampler.addSample(startTime, sampleTime, pass);
        this.totalSampler.addSample(startTime, sampleTime, pass);
        if (this.aggregateThreadGroups) {
            String threadNumber = attributes.getValue("tn");
            Matcher matcher = THREAD_GROUP_PATTERN.matcher(threadNumber);
            String threadGroupName = matcher.matches() ? matcher.group(1) : threadNumber;
            if (threadGroupName.length() == 0) {
                threadGroupName = "null";
            }
            if (!label.equals(threadGroupName)) {
                SamplerImpl threadGroupSampler = (SamplerImpl)this.samplerMap.get(threadGroupName);
                if (threadGroupSampler == null) {
                    threadGroupSampler = new SamplerImpl(threadGroupName);
                    this.samplerMap.put(threadGroupName, threadGroupSampler);
                }
                threadGroupSampler.addSample(startTime, sampleTime, pass);
            }
        }
    }

    private long getLongAttribute(Attributes attributes, String qName) {
        String value = attributes.getValue(qName);
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    private boolean getBooleanAttribute(Attributes attributes, String qName) {
        String value = attributes.getValue(qName);
        if (value == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

