/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jmeter_aggregator.parser;

import com.atlassian.bamboo.plugins.jmeter_aggregator.Sampler;
import com.atlassian.bamboo.plugins.jmeter_aggregator.SamplerImpl;
import com.atlassian.bamboo.plugins.jmeter_aggregator.parser.CsvReader;
import com.atlassian.bamboo.plugins.jmeter_aggregator.parser.SampleResultsParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CsvParser
implements SampleResultsParser {
    private static final String TIMESTAMP = "timestamp";
    private final Map<String, Sampler> samplerMap = new HashMap<String, Sampler>();
    private final String columns;
    private static Logger log = Logger.getLogger(CsvParser.class);

    public CsvParser() {
        this.columns = null;
    }

    public CsvParser(String columns) {
        this.columns = columns;
    }

    @Override
    public Map<String, Sampler> getSamplerMap() {
        return this.samplerMap;
    }

    @Override
    public SamplerImpl getTotalSampler() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File file) throws IOException {
        try (CsvReader reader = new CsvReader(new FileReader(file));){
            List<String> columnNames = this.getColumnNames(reader);
            int timestampColumn = this.initialiseSamplerMap(columnNames);
            if (timestampColumn == -1) {
                log.error((Object)"No timestamp column found in CSV data.  Please ensure you have a column called timestamp");
                return;
            }
            this.extractValues(reader, columnNames, timestampColumn);
        }
    }

    private int initialiseSamplerMap(List<String> columnNames) {
        int timestampColumn = -1;
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            if (columnName != null && !TIMESTAMP.equals(columnName.toLowerCase())) {
                if (this.samplerMap.containsKey(columnName)) continue;
                this.samplerMap.put(columnName, new SamplerImpl(columnName));
                continue;
            }
            if (columnName == null || !TIMESTAMP.equals(columnName.toLowerCase())) continue;
            timestampColumn = i;
        }
        return timestampColumn;
    }

    private void extractValues(CsvReader reader, List<String> columnNames, int timestampColumn) throws IOException {
        String[] csvLine;
        while ((csvLine = reader.readNext()) != null) {
            long timestamp = 0L;
            if (csvLine.length > timestampColumn) {
                timestamp = this.parseLong(csvLine[timestampColumn]);
            }
            for (int i = 0; i < csvLine.length; ++i) {
                String samplerName;
                if (i == timestampColumn || columnNames.size() <= i || (samplerName = columnNames.get(i)) == null) continue;
                SamplerImpl sampler = (SamplerImpl)this.samplerMap.get(samplerName);
                long value = this.parseLong(csvLine[i]);
                sampler.addSample(timestamp, value, true);
            }
        }
    }

    private List<String> getColumnNames(CsvReader reader) throws IOException {
        String[] columnNames;
        if (this.columns != null && this.columns.trim().length() != 0) {
            CsvReader singleLineReader = new CsvReader(new StringReader(this.columns));
            columnNames = singleLineReader.readNext();
        } else {
            columnNames = reader.readNext();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String columnName : columnNames) {
            if (columnName == null || columnName.trim().length() == 0) {
                results.add(null);
                continue;
            }
            results.add(columnName.trim());
        }
        return results;
    }

    private long parseLong(String str) {
        if (str == null) {
            return 0L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }
}

