/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jmeter_aggregator.builder;

import com.atlassian.bamboo.plugins.jmeter_aggregator.Sampler;
import com.atlassian.bamboo.plugins.jmeter_aggregator.util.XStreamFactory;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.XStream;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JmeterBuildDataHelper {
    public static final String CUSTOM_BUILD_DATA_MAP = "jmeter.aggregator.map";
    public static final String CUSTOM_BUILD_DATA_TOTAL = "jmeter.aggregator.total";

    public static boolean isJmeterAggregatorOn(Map<String, String> customConfiguration) {
        return Boolean.valueOf(customConfiguration.get("custom.bamboo.jmeter_aggregation.on"));
    }

    public static void putSamplerDataInCustomData(Map<String, String> customData, Map<String, Sampler> samplerMap, Sampler totalSampler) {
        XStream xstream = XStreamFactory.getXStream();
        String samplerMapXml = xstream.toXML(samplerMap);
        String totalSamplerXml = xstream.toXML((Object)totalSampler);
        customData.put(CUSTOM_BUILD_DATA_MAP, samplerMapXml);
        customData.put(CUSTOM_BUILD_DATA_TOTAL, totalSamplerXml);
    }

    @NotNull
    public static Map<String, Sampler> getSamplerMapFromCustomData(Map<String, String> customData) {
        XStream xstream = XStreamFactory.getXStream();
        String samplerMapXml = customData.get(CUSTOM_BUILD_DATA_MAP);
        if (samplerMapXml != null) {
            try {
                return (Map)xstream.fromXML(samplerMapXml);
            }
            catch (Exception e) {
                return Maps.newHashMap();
            }
        }
        return Maps.newHashMap();
    }

    public static Sampler getTotalSamplerFromCustomData(Map<String, String> customData) {
        XStream xstream = XStreamFactory.getXStream();
        String totalSamplerXml = customData.get(CUSTOM_BUILD_DATA_TOTAL);
        if (totalSamplerXml != null) {
            try {
                return (Sampler)xstream.fromXML(totalSamplerXml);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

