/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jmeter_aggregator.builder;

import com.atlassian.bamboo.build.CustomBuildProcessorServer;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plugins.jmeter_aggregator.Sampler;
import com.atlassian.bamboo.plugins.jmeter_aggregator.builder.JmeterBuildDataHelper;
import com.atlassian.bamboo.plugins.jmeter_aggregator.builder.SamplerAssertion;
import com.atlassian.bamboo.plugins.jmeter_aggregator.web.SamplerMetric;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BaseConfigurablePlugin;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JmeterAggregatorBuildProcessorServer
extends BaseConfigurablePlugin
implements CustomBuildProcessorServer {
    private static final Logger log = Logger.getLogger(JmeterAggregatorBuildProcessorServer.class);
    private BuildContext ctx;
    private boolean on;
    private Sampler previousTotalSampler;
    private Map<String, Sampler> previousSamplerMap;
    private ResultsSummary previousBuildResultsSummary;
    private PlanManager planManager;

    public void init(@NotNull BuildContext ctx) {
        this.ctx = ctx;
        Map conf = ctx.getBuildDefinition().getCustomConfiguration();
        this.on = JmeterBuildDataHelper.isJmeterAggregatorOn(conf);
    }

    @NotNull
    public BuildContext call() {
        if (!this.on) {
            return this.ctx;
        }
        Map<String, Sampler> samplerMap = this.getSamplerMapFromCustomData();
        Sampler totalSampler = this.getTotalSamplerFromCustomData();
        Collection<SamplerAssertion> assertions = this.getSamplerAssertions(this.ctx.getBuildDefinition().getCustomConfiguration());
        for (SamplerAssertion assertion : assertions) {
            String label = assertion.getLabel();
            if ("_TOTAL".equals(label)) {
                this.runAssertion(totalSampler, assertion);
                continue;
            }
            if ("_ANY".equals(label)) {
                for (Sampler sampler : samplerMap.values()) {
                    this.runAssertion(sampler, assertion);
                }
                this.runAssertion(totalSampler, assertion);
                continue;
            }
            this.runAssertion(samplerMap.get(label), assertion);
        }
        return this.ctx;
    }

    protected Sampler getTotalSamplerFromCustomData() {
        return JmeterBuildDataHelper.getTotalSamplerFromCustomData(this.ctx.getBuildResult().getCustomBuildData());
    }

    protected Map<String, Sampler> getSamplerMapFromCustomData() {
        return JmeterBuildDataHelper.getSamplerMapFromCustomData(this.ctx.getBuildResult().getCustomBuildData());
    }

    private void runAssertion(Sampler sampler, SamplerAssertion assertion) {
        long value = assertion.getMetric().getValueFromSampler(sampler).longValue();
        CurrentBuildResult buildResult = this.ctx.getBuildResult();
        boolean pass = true;
        switch (assertion.getAssertionType()) {
            case EQUALS: {
                if (value != assertion.getValue()) break;
                pass = false;
                break;
            }
            case NOT_EQUALS: {
                if (value == assertion.getValue()) break;
                pass = false;
                break;
            }
            case GREATER_THAN: {
                if (value <= assertion.getValue()) break;
                pass = false;
                break;
            }
            case LESS_THAN: {
                if (value >= assertion.getValue()) break;
                pass = false;
                break;
            }
            case DEVIATES_BY: {
                long previousValue;
                Sampler previousSampler = this.getPreviousSampler(sampler);
                if (previousSampler == null || Math.abs(value - (previousValue = this.getValueFromPreviousSampler(assertion, previousSampler))) <= assertion.getValue()) break;
                pass = false;
                break;
            }
            case DEVIATES_UP_BY: {
                long previousValue;
                Sampler previousSampler = this.getPreviousSampler(sampler);
                if (previousSampler == null || value - (previousValue = this.getValueFromPreviousSampler(assertion, previousSampler)) <= assertion.getValue()) break;
                pass = false;
                break;
            }
            case DEVIATES_DOWN_BY: {
                long previousValue;
                Sampler previousSampler = this.getPreviousSampler(sampler);
                if (previousSampler == null || (previousValue = this.getValueFromPreviousSampler(assertion, previousSampler)) - value <= assertion.getValue()) break;
                pass = false;
                break;
            }
            case DEVIATES_BY_PERCENT: {
                long previousValue;
                Sampler previousSampler = this.getPreviousSampler(sampler);
                if (previousSampler == null || (previousValue = this.getValueFromPreviousSampler(assertion, previousSampler)) == 0L || Math.abs(value - previousValue) * 100L / previousValue <= assertion.getValue()) break;
                pass = false;
                break;
            }
            case DEVIATES_UP_BY_PERCENT: {
                long previousValue;
                Sampler previousSampler = this.getPreviousSampler(sampler);
                if (previousSampler == null || (previousValue = this.getValueFromPreviousSampler(assertion, previousSampler)) == 0L || (value - previousValue) * 100L / previousValue <= assertion.getValue()) break;
                pass = false;
                break;
            }
            case DEVIATES_DOWN_BY_PERCENT: {
                long previousValue;
                Sampler previousSampler = this.getPreviousSampler(sampler);
                if (previousSampler == null || (previousValue = this.getValueFromPreviousSampler(assertion, previousSampler)) == 0L || (previousValue - value) * 100L / previousValue <= assertion.getValue()) break;
                pass = false;
            }
        }
        TestResults testResults = this.getTestResults(assertion, sampler, value, pass);
        if (pass) {
            buildResult.appendTestResults(Collections.singleton(testResults), null, null);
        } else {
            buildResult.setBuildState(BuildState.FAILED);
            buildResult.appendTestResults(null, Collections.singleton(testResults), null);
        }
    }

    protected long getValueFromPreviousSampler(SamplerAssertion assertion, Sampler previousSampler) {
        return assertion.getMetric().getValueFromSampler(previousSampler).longValue();
    }

    private TestResults getTestResults(SamplerAssertion assertion, Sampler sampler, long value, boolean pass) {
        String assertionLabel = this.getLabel(assertion.getLabel());
        String samplerLabel = this.getLabel(sampler.getLabel());
        String className = assertionLabel + " " + assertion.getMetric().getDescription() + " " + assertion.getAssertionType().getDescription() + " " + assertion.getValue();
        TestResults results = new TestResults(className, samplerLabel, Long.toString(value / 1000L));
        if (!pass) {
            results.addError((TestCaseResultError)new TestCaseResultErrorImpl("Assertion failed, value was " + value));
            results.setState(TestState.FAILED);
        } else {
            results.setState(TestState.SUCCESS);
        }
        return results;
    }

    private String getLabel(String label) {
        if (label == null || label.equals("_TOTAL")) {
            return "Total of all Samplers";
        }
        if (label.equals("_ANY")) {
            return "Any Sampler";
        }
        return label;
    }

    protected Sampler getPreviousSampler(Sampler sampler) {
        ResultsSummary summary;
        if (sampler.getLabel() == null) {
            ResultsSummary summary2;
            if (this.previousTotalSampler == null && (summary2 = this.getPreviousBuildResultsSummary()) != null) {
                this.previousTotalSampler = this.getTotalSamplerFromCustomData(summary2);
            }
            return this.previousTotalSampler;
        }
        if (this.previousSamplerMap == null && (summary = this.getPreviousBuildResultsSummary()) != null) {
            this.previousSamplerMap = this.getSamplerMapFromCustomData(summary);
        }
        if (this.previousSamplerMap != null) {
            return this.previousSamplerMap.get(sampler.getLabel());
        }
        return null;
    }

    protected Sampler getTotalSamplerFromCustomData(ResultsSummary summary) {
        return JmeterBuildDataHelper.getTotalSamplerFromCustomData(summary.getCustomBuildData());
    }

    protected Map<String, Sampler> getSamplerMapFromCustomData(ResultsSummary summary) {
        return JmeterBuildDataHelper.getSamplerMapFromCustomData(summary.getCustomBuildData());
    }

    private ResultsSummary getPreviousBuildResultsSummary() {
        Plan plan;
        if (this.previousBuildResultsSummary == null && (plan = this.planManager.getPlanByKey(this.ctx.getPlanResultKey().getPlanKey())) != null) {
            this.previousBuildResultsSummary = plan.getLatestResultsSummary();
        }
        return this.previousBuildResultsSummary;
    }

    protected void populateContextForView(@NotNull Map<String, Object> context, @NotNull Plan plan) {
        Map conf = plan.getBuildDefinition().getCustomConfiguration();
        if (JmeterBuildDataHelper.isJmeterAggregatorOn(conf)) {
            context.put("jmeterAggregationOn", true);
            context.put("logFile", conf.get("custom.bamboo.jmeter_aggregation.buildLogFile"));
            context.put("csvLogFile", conf.get("custom.bamboo.jmeter_aggregation.csvLogFile"));
            if (Boolean.valueOf((String)conf.get("custom.bamboo.jmeter_aggregation.aggregateThreadGroups")).booleanValue()) {
                context.put("aggregateThreadGroups", "on");
            } else {
                context.put("aggregateThreadGroups", "off");
            }
            Collection<SamplerAssertion> samplerAssertions = this.getSamplerAssertions(plan.getBuildDefinition().getCustomConfiguration());
            context.put("samplerAssertions", samplerAssertions);
        }
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        ErrorCollection errors = this.superClassValidate(buildConfiguration);
        boolean on = buildConfiguration.getBoolean("custom.bamboo.jmeter_aggregation.on");
        if (on) {
            int assertionCount = 0;
            try {
                String acs = buildConfiguration.getString("custom.bamboo.jmeter_aggregation.assertionCount");
                if (acs != null) {
                    assertionCount = Integer.parseInt(acs);
                }
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)"Error parsing assertion count, no assertions will be loaded");
            }
            for (int i = 0; i < assertionCount; ++i) {
                String keyPrefix = "custom.bamboo.jmeter_aggregation.assertion" + i + ".";
                String valueString = buildConfiguration.getString(keyPrefix + "value");
                if (valueString == null || valueString.length() == 0) {
                    errors.addError(keyPrefix + "errors", "Value must not be blank");
                } else {
                    try {
                        Long.parseLong(valueString);
                    }
                    catch (NumberFormatException nfe) {
                        errors.addError(keyPrefix + "errors", "Value must be a number");
                    }
                }
                String label = buildConfiguration.getString(keyPrefix + "label");
                if (label != null && label.length() != 0) continue;
                errors.addError(keyPrefix + "errors", "Label must not be blank");
            }
            String buildLogFile = buildConfiguration.getString("custom.bamboo.jmeter_aggregation.buildLogFile");
            if (buildLogFile == null || buildLogFile.length() == 0) {
                errors.addError("custom.bamboo.jmeter_aggregation.buildLogFile", "Build Log file must not be blank");
            }
        }
        return errors;
    }

    protected ErrorCollection superClassValidate(BuildConfiguration buildConfiguration) {
        return super.validate(buildConfiguration);
    }

    protected void populateContextForEdit(@NotNull Map<String, Object> ctx, @NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
        super.populateContextForEdit(ctx, buildConfiguration, plan);
        Plan build = this.planManager.getPlanByKey(plan.getPlanKey());
        ResultsSummary summary = build != null ? build.getLatestResultsSummary() : null;
        HashMap samplerValues = Maps.newHashMap();
        samplerValues.put("_ANY", "Any Sampler");
        samplerValues.put("_TOTAL", "Total of all Samplers");
        if (summary != null) {
            Map<String, Sampler> samplerMap = this.getSamplerMapFromCustomData(summary);
            for (String sampler : samplerMap.keySet()) {
                samplerValues.put(sampler, sampler);
            }
        }
        ctx.put("samplervalues", samplerValues);
        ctx.put("assertionvalues", SamplerAssertion.AssertionType.values());
        ctx.put("metricvalues", SamplerMetric.values());
        ctx.put("samplerassertions", this.getSamplerAssertions(buildConfiguration));
        ctx.put("blah", "foo");
    }

    @NotNull
    private Collection<SamplerAssertion> getSamplerAssertions(final BuildConfiguration buildConfiguration) {
        HashMap<String, String> customConfig = new HashMap<String, String>(){

            @Override
            public String get(Object key) {
                return buildConfiguration.getString((String)key);
            }
        };
        return this.getSamplerAssertions((Map<String, String>)customConfig);
    }

    @NotNull
    private Collection<SamplerAssertion> getSamplerAssertions(Map<String, String> configuration) {
        ArrayList assertions = Lists.newArrayList();
        int assertionCount = 0;
        try {
            String acs = configuration.get("custom.bamboo.jmeter_aggregation.assertionCount");
            if (acs != null) {
                assertionCount = Integer.parseInt(acs);
            }
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)"Error parsing assertion count");
        }
        for (int i = 0; i < assertionCount; ++i) {
            SamplerAssertion.AssertionType assertionType;
            SamplerMetric metric;
            String keyPrefix = "custom.bamboo.jmeter_aggregation.assertion" + i + ".";
            String label = configuration.get(keyPrefix + "label");
            String valueString = configuration.get(keyPrefix + "value");
            String metricString = configuration.get(keyPrefix + "metric");
            String assertionString = configuration.get(keyPrefix + "assert");
            if (label == null || valueString == null || metricString == null || assertionString == null) {
                log.error((Object)("Null values for assertion " + i));
                continue;
            }
            long value = 0L;
            try {
                value = Long.parseLong(valueString);
            }
            catch (NumberFormatException nfe) {
                log.error((Object)("Non numeric value for assertion " + i));
            }
            try {
                metric = this.getSamplerMetric(metricString);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)("Invalid metric " + metricString + " for assertion " + i));
                continue;
            }
            try {
                assertionType = SamplerAssertion.AssertionType.valueOf(assertionString);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)("Invalid assertion " + assertionString + " for assertion " + i));
                continue;
            }
            SamplerAssertion samplerAssertion = new SamplerAssertion(value, assertionType, metric, label);
            assertions.add(samplerAssertion);
        }
        return assertions;
    }

    protected SamplerMetric getSamplerMetric(String metricString) {
        return SamplerMetric.valueOf(metricString);
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }
}

