/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jmeter_aggregator.builder;

import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.plugins.jmeter_aggregator.Sampler;
import com.atlassian.bamboo.plugins.jmeter_aggregator.SimpleSampler;
import com.atlassian.bamboo.plugins.jmeter_aggregator.builder.JmeterBuildDataHelper;
import com.atlassian.bamboo.plugins.jmeter_aggregator.parser.CsvParser;
import com.atlassian.bamboo.plugins.jmeter_aggregator.parser.JtlSaxHandler;
import com.atlassian.bamboo.plugins.jmeter_aggregator.parser.SampleResultsParser;
import com.atlassian.bamboo.utils.FileVisitor;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JmeterAggregatorBuildProcessor
implements CustomBuildProcessor {
    private BuildContext ctx;
    private boolean on;
    private boolean aggregateThreadGroups;
    private String buildLogFile;
    private String csvLogFile;
    private String csvHeader;
    private boolean csvCustomHeader;
    private static final Logger log = Logger.getLogger(JmeterAggregatorBuildProcessor.class);

    @NotNull
    public BuildContext call() throws Exception {
        File source;
        if (!this.on) {
            return this.ctx;
        }
        try {
            source = new File((String)this.ctx.getBuildResult().getCustomBuildData().get("working.directory"));
        }
        catch (NullPointerException npe) {
            return this.ctx;
        }
        SimpleSampler totalSampler = new SimpleSampler();
        HashMap simpleSamplerMap = Maps.newHashMap();
        if (this.buildLogFile != null && this.buildLogFile.trim().length() > 0) {
            JtlSaxHandler jtlParser = new JtlSaxHandler(this.aggregateThreadGroups);
            XMLReader saxParser = XMLReaderFactory.createXMLReader();
            saxParser.setContentHandler(jtlParser);
            FileVisitor fileVisitor = this.newFileVisitorBuildLog(source, saxParser);
            this.visitFilesAndCollectResults(simpleSamplerMap, fileVisitor, jtlParser, this.buildLogFile);
            PropertyUtils.copyProperties((Object)totalSampler, (Object)jtlParser.getTotalSampler());
        }
        if (this.csvLogFile != null && this.csvLogFile.trim().length() > 0) {
            CsvParser csvParser = this.csvCustomHeader ? new CsvParser(this.csvHeader) : new CsvParser();
            FileVisitor fileVisitor = this.newFileVisitorCsvLog(source, csvParser);
            this.visitFilesAndCollectResults(simpleSamplerMap, fileVisitor, csvParser, this.csvLogFile);
        }
        JmeterBuildDataHelper.putSamplerDataInCustomData(this.ctx.getBuildResult().getCustomBuildData(), simpleSamplerMap, totalSampler);
        return this.ctx;
    }

    protected FileVisitor newFileVisitorCsvLog(File source, final CsvParser csvParser) {
        return new FileVisitor(source){

            public void visitFile(File file) {
                try {
                    csvParser.parse(file);
                }
                catch (FileNotFoundException fnfe) {
                    log.warn((Object)"Error parsing CSV output file", (Throwable)fnfe);
                    JmeterAggregatorBuildProcessor.this.ctx.getErrorCollection().addErrorMessage("Error parsing CSV output file: " + file + "  Is this a directory?  Please check your configuration so that it only matches the CSV files you want to include in the results.");
                }
                catch (IOException ioe) {
                    log.warn((Object)"Error parsing CSV output file", (Throwable)ioe);
                    JmeterAggregatorBuildProcessor.this.ctx.getErrorCollection().addErrorMessage("Error parsing CSV output file: " + file, (Exception)ioe);
                }
            }
        };
    }

    protected FileVisitor newFileVisitorBuildLog(File source, final XMLReader saxParser) {
        return new FileVisitor(source){

            public void visitFile(File file) {
                try {
                    saxParser.parse(new InputSource(new FileReader(file)));
                }
                catch (SAXException se) {
                    log.warn((Object)"Error parsing JMeter output file", (Throwable)se);
                    JmeterAggregatorBuildProcessor.this.ctx.getErrorCollection().addErrorMessage("Error parsing JMeter output file: " + file, (Exception)se);
                }
                catch (IOException ioe) {
                    log.warn((Object)"Error parsing JMeter output file", (Throwable)ioe);
                    JmeterAggregatorBuildProcessor.this.ctx.getErrorCollection().addErrorMessage("Error parsing JMeter output file: " + file, (Exception)ioe);
                }
            }
        };
    }

    private void visitFilesAndCollectResults(Map<String, Sampler> samplers, FileVisitor fileVisitor, SampleResultsParser parser, String filePattern) throws Exception {
        fileVisitor.visitFilesThatMatch(filePattern);
        for (Map.Entry<String, Sampler> samplerMapEntry : parser.getSamplerMap().entrySet()) {
            SimpleSampler simpleSampler = new SimpleSampler();
            try {
                PropertyUtils.copyProperties((Object)simpleSampler, (Object)samplerMapEntry.getValue());
            }
            catch (Exception e) {
                log.error((Object)"Error copying properties", (Throwable)e);
            }
            samplers.put(samplerMapEntry.getKey(), simpleSampler);
        }
    }

    public void init(@NotNull BuildContext ctx) {
        this.ctx = ctx;
        Map conf = ctx.getBuildDefinition().getCustomConfiguration();
        boolean bl = this.on = conf != null && Boolean.valueOf((String)conf.get("custom.bamboo.jmeter_aggregation.on")) != false;
        if (this.on) {
            this.buildLogFile = (String)conf.get("custom.bamboo.jmeter_aggregation.buildLogFile");
            this.csvLogFile = (String)conf.get("custom.bamboo.jmeter_aggregation.csvLogFile");
            this.csvHeader = (String)conf.get("custom.bamboo.jmeter_aggregation.csvHeader");
            this.csvCustomHeader = Boolean.valueOf((String)conf.get("custom.bamboo.jmeter_aggregation.csvCustomHeader"));
            this.aggregateThreadGroups = Boolean.valueOf((String)conf.get("custom.bamboo.jmeter_aggregation.aggregateThreadGroups"));
        }
    }
}

