/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.jmeter_aggregator;

import com.atlassian.bamboo.plugins.jmeter_aggregator.Sampler;
import java.util.AbstractList;
import java.util.Arrays;

public class SamplerImpl
implements Sampler {
    private static final long ONE_MINUTE = 60000L;
    private final String label;
    private final PrimitiveLongList samples;
    private int successCount = 0;
    private long startTime = Long.MAX_VALUE;
    private long finishTime = 0L;
    private long maxValue = 0L;
    private long minValue = Long.MAX_VALUE;
    private long totalValue = 0L;
    private double meanValue = 0.0;
    private double varianceTimesCount = 0.0;
    private long medianValue = -1L;
    private long ninetyPercentValue = -1L;
    private long throughput = -1L;
    private int percentSuccess = -1;
    private long totalTime = -1L;
    private int count = 0;

    public SamplerImpl(String label) {
        this.label = label;
        this.samples = new PrimitiveLongList();
    }

    public void addSample(long startTime, long value, boolean pass) {
        ++this.count;
        if (pass) {
            ++this.successCount;
        }
        this.samples.add(value);
        if (startTime < this.startTime) {
            this.startTime = startTime;
        }
        if (startTime > this.finishTime) {
            this.finishTime = startTime;
        }
        if (value > this.maxValue) {
            this.maxValue = value;
        }
        if (value < this.minValue) {
            this.minValue = value;
        }
        this.totalValue += value;
        double delta = (double)value - this.meanValue;
        this.meanValue += delta / (double)this.count;
        this.varianceTimesCount += delta * ((double)value - this.meanValue);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getSuccessCount() {
        return this.successCount;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getFinishTime() {
        return this.finishTime;
    }

    @Override
    public long getMaxValue() {
        return this.maxValue;
    }

    @Override
    public long getMinValue() {
        return this.minValue;
    }

    @Override
    public long getTotalValue() {
        return this.totalValue;
    }

    @Override
    public long getMedianValue() {
        if (this.medianValue == -1L) {
            this.medianValue = SamplerImpl.select(this.samples.getPrimitiveArray(), this.count / 2, 0, this.count);
        }
        return this.medianValue;
    }

    @Override
    public long getNinetyPercentValue() {
        if (this.ninetyPercentValue == -1L) {
            int ninetyPercent = (int)Math.floor((double)this.count * 0.9);
            this.ninetyPercentValue = SamplerImpl.select(this.samples.getPrimitiveArray(), ninetyPercent, 0, this.count);
        }
        return this.ninetyPercentValue;
    }

    @Override
    public long getThroughput() {
        if (this.throughput == -1L) {
            this.throughput = this.getTotalTime() > 0L ? (long)((double)this.count / ((double)this.getTotalTime() / 60000.0)) : 0L;
        }
        return this.throughput;
    }

    @Override
    public long getAverageValue() {
        if (this.meanValue == -1.0) {
            this.meanValue = this.count != 0 ? (double)(this.totalValue / (long)this.count) : 0.0;
        }
        return (long)this.meanValue;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public int getPercentSuccess() {
        if (this.percentSuccess == -1) {
            this.percentSuccess = this.count != 0 ? this.successCount * 100 / this.count : 0;
        }
        return this.percentSuccess;
    }

    @Override
    public long getTotalTime() {
        if (this.totalTime == -1L) {
            this.totalTime = this.finishTime - this.startTime;
        }
        return this.totalTime;
    }

    @Override
    public long getStandardDeviation() {
        if (this.count > 0) {
            return (long)Math.sqrt(this.varianceTimesCount / (double)this.count);
        }
        return 0L;
    }

    static long select(long[] list, int k, int left, int right) {
        int length = right - left;
        if (length < 1) {
            return 0L;
        }
        if (length <= 5) {
            Arrays.sort(list, left, right);
            return list[k];
        }
        int ml = (int)Math.ceil((double)length / 5.0);
        long[] medians = new long[ml];
        for (int i = 0; i < ml; ++i) {
            int l = left + i * 5;
            int r = l + 5;
            if (r > right) {
                r = right;
            }
            Arrays.sort(list, l, r);
            medians[i] = list[l + (r - l) / 2];
        }
        int pk = (int)Math.ceil((double)length / 10.0);
        long pivotValue = SamplerImpl.select(medians, pk, 0, ml);
        int pivotNewIndex = SamplerImpl.partition(list, left, right, pivotValue, k);
        if (k == pivotNewIndex) {
            return pivotValue;
        }
        if (k < pivotNewIndex) {
            return SamplerImpl.select(list, k, left, pivotNewIndex);
        }
        return SamplerImpl.select(list, k, pivotNewIndex, right);
    }

    static int partition(long[] list, int left, int right, long pivotValue, int preferredIndex) {
        int i;
        int storeIndex = left;
        int storeRight = right;
        for (i = left; i < storeRight; ++i) {
            long value = list[i];
            if (value < pivotValue) {
                long tmp = list[storeIndex];
                list[storeIndex] = list[i];
                list[i] = tmp;
                ++storeIndex;
                continue;
            }
            if (value != pivotValue) continue;
            list[i] = list[--storeRight];
            --i;
        }
        for (i = 0; i < right - storeRight && i < storeRight - storeIndex; ++i) {
            list[right - 1 - i] = list[storeIndex + i];
        }
        for (i = 0; i < right - storeRight; ++i) {
            list[storeIndex + i] = pivotValue;
        }
        if (preferredIndex < storeIndex) {
            return storeIndex;
        }
        if (preferredIndex >= storeIndex + (right - storeRight)) {
            return storeIndex + (right - storeRight) - 1;
        }
        return preferredIndex;
    }

    private class PrimitiveLongList
    extends AbstractList<Long> {
        private long[] data = new long[10];
        private int size = 0;

        @Override
        public Long get(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException(Integer.toString(i));
            }
            return this.data[i];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(Long element) {
            if (this.data.length == this.size) {
                long[] oldData = this.data;
                this.data = new long[oldData.length * 3 / 2 + 1];
                System.arraycopy(oldData, 0, this.data, 0, this.size);
            }
            this.data[this.size] = element;
            ++this.size;
            return true;
        }

        public long[] getPrimitiveArray() {
            return this.data;
        }
    }
}

