/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo.util;

import io.qameta.allure.bamboo.AllurePluginException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipUtil.class);
    private static final String DIRECTORY_CREATE_ERROR = "The directory: %s couldn't be created successfully";

    private ZipUtil() {
    }

    public static void unzip(@NotNull Path zipFilePath, String outputDir) throws IOException, ArchiveException {
        ArchiveStreamFactory asf = new ArchiveStreamFactory();
        try (InputStream zipStream = Files.newInputStream(zipFilePath, new OpenOption[0]);
             ArchiveInputStream ais = asf.createArchiveInputStream("zip", zipStream);){
            ArchiveEntry entry = ais.getNextEntry();
            while (entry != null) {
                Path entryPath = Paths.get(outputDir, entry.getName());
                File entryFile = entryPath.toFile();
                if (!entry.isDirectory()) {
                    File parentEntryFile = entryFile.getParentFile();
                    if (parentEntryFile.isDirectory() && !parentEntryFile.mkdirs() && !parentEntryFile.exists()) {
                        throw new IOException(String.format(DIRECTORY_CREATE_ERROR, parentEntryFile.getPath()));
                    }
                    try (OutputStream outputStream = Files.newOutputStream(entryPath, new OpenOption[0]);){
                        IOUtils.copy((InputStream)ais, (OutputStream)outputStream);
                    }
                } else if (!entryFile.mkdirs() && !entryFile.exists()) {
                    throw new IOException(String.format(DIRECTORY_CREATE_ERROR, entryFile.getPath()));
                }
                entry = ais.getNextEntry();
            }
        }
    }

    public static void zipReportFolder(@NotNull Path srcFolder, @NotNull Path targetDir) throws IOException {
        try {
            Path zipReportTmpDir = Files.createTempDirectory("tmp_allure_report", new FileAttribute[0]);
            Path zipReport = zipReportTmpDir.resolve("report.zip");
            try (ZipFile zp = new ZipFile(zipReport.toFile());){
                zp.addFolder(srcFolder.toFile());
            }
            Files.move(zipReport, targetDir, StandardCopyOption.REPLACE_EXISTING);
            FileUtils.deleteQuietly((File)zipReportTmpDir.toFile());
        }
        catch (Exception e) {
            LOGGER.error("Failed to zip allure report", (Throwable)e);
            throw new AllurePluginException("Unexpected error", e);
        }
    }
}

