/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class Downloader {
    private static final int CONN_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(Integer.getInteger("allure.download.conn.timeout.sec", 20).intValue());
    private static final int DOWNLOAD_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(Integer.getInteger("allure.download.timeout.sec", 120).intValue());

    private Downloader() {
    }

    public static Optional<Path> download(URL url, Path target) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(CONN_TIMEOUT_MS);
        connection.setReadTimeout(DOWNLOAD_TIMEOUT_MS);
        connection.setRequestProperty("Connection", "close");
        connection.setRequestProperty("Pragma", "no-cache");
        ((HttpURLConnection)connection).setInstanceFollowRedirects(true);
        connection.connect();
        try (InputStream input = connection.getInputStream();){
            Files.copy(input, target, StandardCopyOption.REPLACE_EXISTING);
            Optional<Path> optional = Optional.of(target);
            return optional;
        }
    }
}

