/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo.info;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAddInfo
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAddInfo.class);

    public Path invoke(File file) {
        Path outputDirectory = Paths.get(file.toURI());
        try {
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create output directory " + outputDirectory, (Throwable)e);
        }
        Path testRun = outputDirectory.resolve(this.getFileName());
        try (BufferedWriter writer = Files.newBufferedWriter(testRun, StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonMapper mapper = new JsonMapper();
            mapper.writeValue((Writer)writer, this.getData());
        }
        catch (Exception e) {
            LOGGER.error("Failed to add executor info into the file " + file.getAbsolutePath(), (Throwable)e);
        }
        return testRun;
    }

    protected abstract Object getData();

    protected abstract String getFileName();
}

