/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.struts.Preparable;
import io.qameta.allure.bamboo.AllureGlobalConfig;
import io.qameta.allure.bamboo.AllureSettingsManager;
import org.apache.commons.lang3.StringUtils;

public class ConfigureAllureReportAction
extends GlobalAdminAction
implements Preparable {
    private final transient AllureSettingsManager settingsManager;
    private AllureGlobalConfig config;
    private boolean downloadEnabled;
    private boolean customLogoEnabled;
    private boolean enabledByDefault;
    private boolean enabledReportsCleanup;
    private String localStoragePath;
    private String downloadBaseUrl;

    public ConfigureAllureReportAction(AllureSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public String execute() {
        AllureGlobalConfig newConfig = new AllureGlobalConfig(this.downloadEnabled, this.enabledByDefault, this.downloadBaseUrl, this.localStoragePath, this.customLogoEnabled, this.enabledReportsCleanup);
        this.settingsManager.saveSettings(newConfig);
        this.config = this.settingsManager.getSettings();
        return "success";
    }

    public String input() {
        this.downloadEnabled = this.config.isDownloadEnabled();
        this.customLogoEnabled = this.config.isCustomLogoEnabled();
        this.enabledByDefault = this.config.isEnabledByDefault();
        this.enabledReportsCleanup = this.config.isEnabledReportsCleanup();
        this.localStoragePath = this.config.getLocalStoragePath();
        this.downloadBaseUrl = this.config.getDownloadBaseUrl();
        return "input";
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.downloadBaseUrl)) {
            this.addActionError(this.getText("allure.config.download.url.error.required"));
        }
        if (StringUtils.isBlank((CharSequence)this.localStoragePath)) {
            this.addActionError(this.getText("allure.config.local.storage.required"));
        }
    }

    public void prepare() {
        this.config = this.settingsManager.getSettings();
    }

    public boolean isDownloadEnabled() {
        return this.downloadEnabled;
    }

    public void setDownloadEnabled(boolean downloadEnabled) {
        this.downloadEnabled = downloadEnabled;
    }

    public boolean isCustomLogoEnabled() {
        return this.customLogoEnabled;
    }

    public void setCustomLogoEnabled(boolean customLogoEnabled) {
        this.customLogoEnabled = customLogoEnabled;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public void setEnabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
    }

    public boolean isEnabledReportsCleanup() {
        return this.enabledReportsCleanup;
    }

    public void setEnabledReportsCleanup(boolean enabledReportsCleanup) {
        this.enabledReportsCleanup = enabledReportsCleanup;
    }

    public String getLocalStoragePath() {
        return this.localStoragePath;
    }

    public void setLocalStoragePath(String localStoragePath) {
        this.localStoragePath = localStoragePath;
    }

    public String getDownloadBaseUrl() {
        return this.downloadBaseUrl;
    }

    public void setDownloadBaseUrl(String downloadBaseUrl) {
        this.downloadBaseUrl = downloadBaseUrl;
    }
}

