/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class AllureGlobalConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_DOWNLOAD_BASE_URL = "https://github.com/allure-framework/allure2/releases/download/";
    private static final String DEFAULT_CLI_BASE_URL = "https://repo.maven.apache.org/maven2/io/qameta/allure/";
    public static final String DEFAULT_LOCAL_STORAGE_PATH = new File(SystemUtils.getJavaIoTmpDir(), "allure-reports").getPath();
    private final boolean downloadEnabled;
    private final boolean customLogoEnabled;
    private final boolean enabledByDefault;
    private final boolean enabledReportsCleanup;
    private final String localStoragePath;
    private final String downloadBaseUrl;
    private final String downloadCliBaseUrl;

    public AllureGlobalConfig() {
        this(Boolean.TRUE.toString(), Boolean.FALSE.toString(), DEFAULT_DOWNLOAD_BASE_URL, DEFAULT_LOCAL_STORAGE_PATH, DEFAULT_CLI_BASE_URL, Boolean.TRUE.toString(), Boolean.FALSE.toString());
    }

    public AllureGlobalConfig(String downloadEnabled, String enabledByDefault, String downloadBaseUrl, String localStoragePath, String cmdLineUrl, String customLogoEnable, String enabledReportsCleanup) {
        this.downloadEnabled = StringUtils.isBlank((CharSequence)downloadEnabled) ? Boolean.TRUE : Boolean.parseBoolean(downloadEnabled);
        this.enabledByDefault = StringUtils.isBlank((CharSequence)enabledByDefault) ? Boolean.FALSE : Boolean.parseBoolean(enabledByDefault);
        this.downloadBaseUrl = StringUtils.isBlank((CharSequence)downloadBaseUrl) ? DEFAULT_DOWNLOAD_BASE_URL : downloadBaseUrl;
        this.downloadCliBaseUrl = StringUtils.isBlank((CharSequence)cmdLineUrl) ? DEFAULT_CLI_BASE_URL : cmdLineUrl;
        this.localStoragePath = StringUtils.isBlank((CharSequence)localStoragePath) ? DEFAULT_LOCAL_STORAGE_PATH : localStoragePath;
        this.customLogoEnabled = StringUtils.isBlank((CharSequence)customLogoEnable) ? Boolean.TRUE : Boolean.parseBoolean(customLogoEnable);
        this.enabledReportsCleanup = StringUtils.isBlank((CharSequence)enabledReportsCleanup) ? Boolean.FALSE : Boolean.parseBoolean(enabledReportsCleanup);
    }

    public AllureGlobalConfig(boolean downloadEnabled, boolean enabledByDefault, String downloadBaseUrl, String localStoragePath, boolean customLogoEnable, boolean enabledReportsCleanup) {
        this.downloadEnabled = downloadEnabled;
        this.enabledByDefault = enabledByDefault;
        this.downloadBaseUrl = StringUtils.isBlank((CharSequence)downloadBaseUrl) ? DEFAULT_DOWNLOAD_BASE_URL : downloadBaseUrl;
        this.downloadCliBaseUrl = DEFAULT_CLI_BASE_URL;
        this.localStoragePath = StringUtils.isBlank((CharSequence)localStoragePath) ? DEFAULT_LOCAL_STORAGE_PATH : localStoragePath;
        this.customLogoEnabled = customLogoEnable;
        this.enabledReportsCleanup = enabledReportsCleanup;
    }

    boolean isDownloadEnabled() {
        return this.downloadEnabled;
    }

    boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    boolean isCustomLogoEnabled() {
        return this.customLogoEnabled;
    }

    boolean isEnabledReportsCleanup() {
        return this.enabledReportsCleanup;
    }

    String getDownloadBaseUrl() {
        return this.downloadBaseUrl;
    }

    String getDownloadCliBaseUrl() {
        return this.downloadCliBaseUrl;
    }

    public String getLocalStoragePath() {
        return this.localStoragePath;
    }
}

