/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.plugin.web.Condition;
import io.qameta.allure.bamboo.AllureBuildResult;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureViewReportCondition
implements Condition {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureViewReportCondition.class);
    private final ResultsSummaryManager resultsSummaryManager;

    public AllureViewReportCondition(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void init(Map<String, String> context) {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String buildKey = StringUtils.defaultString((String)((String)context.get("planKey")), (String)((String)context.get("buildKey")));
        String buildNumberString = (String)context.get("buildNumber");
        if (StringUtils.isBlank((CharSequence)buildKey) || StringUtils.isBlank((CharSequence)buildNumberString)) {
            return false;
        }
        try {
            int buildNumber = Integer.parseInt(buildNumberString);
            ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((String)buildKey, (int)buildNumber));
            if (resultsSummary != null) {
                AllureBuildResult buildResult = AllureBuildResult.fromCustomData(resultsSummary.getCustomBuildData());
                return buildResult.hasInfo() && (resultsSummary.isFinished() || resultsSummary.isNotBuilt());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to evaluate condition", (Throwable)e);
        }
        return false;
    }
}

