/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import io.qameta.allure.bamboo.AllureGlobalConfig;

public class AllureSettingsManager {
    private final PluginSettings settings;

    public AllureSettingsManager(PluginSettingsFactory settingsFactory) {
        this.settings = settingsFactory.createGlobalSettings();
    }

    AllureGlobalConfig getSettings() {
        String downloadEnabled = (String)this.settings.get("custom.allure.config.download.enabled");
        String customLogoEnabled = (String)this.settings.get("custom.allure.config.logo.enabled");
        String enableByDefault = (String)this.settings.get("custom.allure.config.enabled.default");
        String downloadBaseUrl = (String)this.settings.get("custom.allure.config.download.url");
        String downloadCliBaseUrl = (String)this.settings.get("custom.allure.config.download.cli.url");
        String localStorage = (String)this.settings.get("custom.allure.config.local.storage");
        String enabledReportsCleanup = (String)this.settings.get("custom.allure.config.reports.cleanup.enabled");
        return new AllureGlobalConfig(downloadEnabled, enableByDefault, downloadBaseUrl, localStorage, downloadCliBaseUrl, customLogoEnabled, enabledReportsCleanup);
    }

    void saveSettings(AllureGlobalConfig config) {
        this.settings.put("custom.allure.config.download.enabled", (Object)String.valueOf(config.isDownloadEnabled()));
        this.settings.put("custom.allure.config.logo.enabled", (Object)String.valueOf(config.isCustomLogoEnabled()));
        this.settings.put("custom.allure.config.download.url", (Object)String.valueOf(config.getDownloadBaseUrl()));
        this.settings.put("custom.allure.config.local.storage", (Object)String.valueOf(config.getLocalStoragePath()));
        this.settings.put("custom.allure.config.enabled.default", (Object)String.valueOf(config.isEnabledByDefault()));
        this.settings.put("custom.allure.config.reports.cleanup.enabled", (Object)String.valueOf(config.isEnabledReportsCleanup()));
    }
}

