/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

class AllureGlobalConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_DOWNLOAD_BASE_URL = "https://github.com/allure-framework/allure2/releases/download/";
    private static final String DEFAULT_CLI_BASE_URL = "https://repo.maven.apache.org/maven2/io/qameta/allure/";
    public static final String DEFAULT_LOCAL_STORAGE_PATH = new File(SystemUtils.getJavaIoTmpDir(), "allure-reports").getPath();
    private final boolean downloadEnabled;
    private final boolean customLogoEnabled;
    private final boolean enabledByDefault;
    private final boolean enabledReportsCleanup;
    private final String localStoragePath;
    private final String downloadBaseUrl;
    private final String downloadCliBaseUrl;

    AllureGlobalConfig() {
        this(Boolean.TRUE.toString(), Boolean.FALSE.toString(), DEFAULT_DOWNLOAD_BASE_URL, DEFAULT_LOCAL_STORAGE_PATH, DEFAULT_CLI_BASE_URL, Boolean.TRUE.toString(), Boolean.FALSE.toString());
    }

    AllureGlobalConfig(String downloadEnabled, String enabledByDefault, String downloadBaseUrl, String localStoragePath, String cmdLineUrl, String customLogoEnable, String enabledReportsCleanup) {
        this.downloadEnabled = StringUtils.isBlank((CharSequence)downloadEnabled) ? Boolean.TRUE : Boolean.parseBoolean(downloadEnabled);
        this.enabledByDefault = StringUtils.isBlank((CharSequence)enabledByDefault) ? Boolean.FALSE : Boolean.parseBoolean(enabledByDefault);
        this.downloadBaseUrl = StringUtils.isBlank((CharSequence)downloadBaseUrl) ? DEFAULT_DOWNLOAD_BASE_URL : downloadBaseUrl;
        this.downloadCliBaseUrl = StringUtils.isBlank((CharSequence)cmdLineUrl) ? DEFAULT_CLI_BASE_URL : cmdLineUrl;
        this.localStoragePath = StringUtils.isBlank((CharSequence)localStoragePath) ? DEFAULT_LOCAL_STORAGE_PATH : localStoragePath;
        this.customLogoEnabled = StringUtils.isBlank((CharSequence)customLogoEnable) ? Boolean.TRUE : Boolean.parseBoolean(customLogoEnable);
        this.enabledReportsCleanup = StringUtils.isBlank((CharSequence)enabledReportsCleanup) ? Boolean.FALSE : Boolean.parseBoolean(enabledReportsCleanup);
    }

    @NotNull
    static AllureGlobalConfig fromContext(Map context) {
        return new AllureGlobalConfig(AllureGlobalConfig.getSingleValue(context, "custom.allure.config.download.enabled", Boolean.FALSE.toString()), AllureGlobalConfig.getSingleValue(context, "custom.allure.config.enabled.default", Boolean.FALSE.toString()), AllureGlobalConfig.getSingleValue(context, "custom.allure.config.download.url", DEFAULT_DOWNLOAD_BASE_URL), AllureGlobalConfig.getSingleValue(context, "custom.allure.config.local.storage", DEFAULT_LOCAL_STORAGE_PATH), AllureGlobalConfig.getSingleValue(context, "custom.allure.config.download.cli.url", DEFAULT_CLI_BASE_URL), AllureGlobalConfig.getSingleValue(context, "custom.allure.config.logo.enabled", Boolean.FALSE.toString()), AllureGlobalConfig.getSingleValue(context, "custom.allure.config.reports.cleanup.enabled", Boolean.FALSE.toString()));
    }

    @Nullable
    private static String getSingleValue(Map context, String key, String defaultVal) {
        return Optional.ofNullable(context.get(key)).map(value -> value instanceof String[] ? ((String[])value)[0] : (String)value).orElse(defaultVal);
    }

    void toContext(@NotNull Map<String, Object> context) {
        context.put("custom.allure.config.download.enabled", this.isDownloadEnabled());
        context.put("custom.allure.config.enabled.default", this.isEnabledByDefault());
        context.put("custom.allure.config.download.url", this.getDownloadBaseUrl());
        context.put("custom.allure.config.download.cli.url", this.getDownloadCliBaseUrl());
        context.put("custom.allure.config.local.storage", this.getLocalStoragePath());
        context.put("custom.allure.config.logo.enabled", this.isCustomLogoEnabled());
        context.put("custom.allure.config.reports.cleanup.enabled", this.isEnabledReportsCleanup());
    }

    boolean isDownloadEnabled() {
        return this.downloadEnabled;
    }

    boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    boolean isCustomLogoEnabled() {
        return this.customLogoEnabled;
    }

    boolean isEnabledReportsCleanup() {
        return this.enabledReportsCleanup;
    }

    String getDownloadBaseUrl() {
        return this.downloadBaseUrl;
    }

    String getDownloadCliBaseUrl() {
        return this.downloadCliBaseUrl;
    }

    public String getLocalStoragePath() {
        return this.localStoragePath;
    }
}

