/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class AllureBuildConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ARTIFACT_NAME = "allure-results";
    private static final String DEFAULT_CUSTOM_LOGO_URL = "https://qameta.io/allure-report/img/reportlogo.svg";
    private final boolean onlyForFailed;
    private final String executable;
    private final boolean enabled;
    private final String artifactName;
    private final String logoUrl;
    private final Integer maxStoredReportsCount;

    private AllureBuildConfig(String executable, String enabled, String onlyForFailed, String artifactName, String logoUrl, String maxStoredReportsCount) {
        this.onlyForFailed = StringUtils.isBlank((CharSequence)onlyForFailed) ? Boolean.TRUE : Boolean.parseBoolean(onlyForFailed);
        this.enabled = StringUtils.isBlank((CharSequence)enabled) ? Boolean.FALSE : Boolean.parseBoolean(enabled);
        this.executable = executable;
        this.artifactName = artifactName;
        this.logoUrl = StringUtils.isBlank((CharSequence)logoUrl) ? DEFAULT_CUSTOM_LOGO_URL : logoUrl;
        this.maxStoredReportsCount = StringUtils.isBlank((CharSequence)maxStoredReportsCount) || !StringUtils.isNumeric((CharSequence)maxStoredReportsCount) ? -1 : NumberUtils.toInt((String)maxStoredReportsCount);
    }

    static AllureBuildConfig fromContext(Map<String, String> context) {
        return new AllureBuildConfig(AllureBuildConfig.getSingleValue(context, "custom.allure.config.executable", null), AllureBuildConfig.getSingleValue(context, "custom.allure.config.enabled", Boolean.FALSE.toString()), AllureBuildConfig.getSingleValue(context, "custom.allure.config.failed.only", Boolean.FALSE.toString()), AllureBuildConfig.getSingleValue(context, "custom.allure.artifact.name", DEFAULT_ARTIFACT_NAME), AllureBuildConfig.getSingleValue(context, "custom.allure.logo.url", DEFAULT_CUSTOM_LOGO_URL), AllureBuildConfig.getSingleValue(context, "custom.allure.max.stored.reports.count", null));
    }

    @Nullable
    private static String getSingleValue(Map context, String key, String defaultVal) {
        return Optional.ofNullable(context.get(key)).map(value -> value instanceof String[] ? ((String[])value)[0] : (String)value).orElse(defaultVal);
    }

    boolean isOnlyForFailed() {
        return this.onlyForFailed;
    }

    boolean isEnabledSet() {
        return this.enabled;
    }

    public String getExecutable() {
        return this.executable;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getCustomLogoUrl() {
        return this.logoUrl;
    }

    public Integer getMaxStoredReportsCount() {
        return this.maxStoredReportsCount;
    }
}

