/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.artifact.MutableArtifactImpl;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.artifact.AbstractArtifactHandler;
import com.atlassian.bamboo.build.artifact.AgentLocalArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactFileData;
import com.atlassian.bamboo.build.artifact.ArtifactHandler;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResultImpl;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.artifact.ArtifactPublishingConfig;
import com.atlassian.bamboo.build.artifact.BambooRemoteArtifactHandler;
import com.atlassian.bamboo.build.artifact.FileSystemArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.TrampolineArtifactFileData;
import com.atlassian.bamboo.build.artifact.handlers.ArtifactHandlersService;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContextImpl;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.ArtifactHandlerModuleDescriptorImpl;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleOfClassPredicate;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import io.qameta.allure.bamboo.AllureBuildResult;
import io.qameta.allure.bamboo.AllurePluginException;
import io.qameta.allure.bamboo.AllureSettingsManager;
import io.qameta.allure.bamboo.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureArtifactsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureArtifactsManager.class);
    private static final String REPORTS_SUBDIR = "allure-reports";
    private static final String FAILED_TO_DOWNLOAD_ARTIFACTS_TO = "Failed to download artifacts to ";
    private static final String INDEX_HTML = "index.html";
    private static final int SINGLE_NUMBER_OF_LIST_ELEMENTS = 1;
    private final PluginAccessor pluginAccessor;
    private final ArtifactHandlersService artifactHandlersService;
    private final BuildDefinitionManager buildDefinitionManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final ArtifactLinkManager artifactLinkManager;
    private final ApplicationProperties appProperties;
    private final AllureSettingsManager settingsManager;

    public AllureArtifactsManager(PluginAccessor pluginAccessor, ArtifactHandlersService artifactHandlersService, BuildDefinitionManager buildDefinitionManager, ResultsSummaryManager resultsSummaryManager, ArtifactLinkManager artifactLinkManager, ApplicationProperties appProperties, AllureSettingsManager settingsManager) {
        this.pluginAccessor = pluginAccessor;
        this.artifactHandlersService = artifactHandlersService;
        this.buildDefinitionManager = buildDefinitionManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.artifactLinkManager = artifactLinkManager;
        this.appProperties = appProperties;
        this.settingsManager = settingsManager;
    }

    Optional<String> getArtifactUrl(String planKeyString, String buildNumber, String filePath) {
        BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition(PlanKeys.getPlanKey((String)planKeyString));
        Map<String, String> artifactConfig = this.getArtifactHandlersConfig(buildDefinition);
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)planKeyString, (int)Integer.parseInt(buildNumber));
        return Optional.ofNullable(this.resultsSummaryManager.getResultsSummary(planResultKey)).flatMap(rs -> this.getArtifactHandlerByClassName(AllureBuildResult.fromCustomData(rs.getCustomBuildData()).getArtifactHandlerClass()).map(handler -> this.getArtifactUrl(planKeyString, buildNumber, filePath, artifactConfig, planResultKey, (ArtifactHandler)handler)));
    }

    private String getArtifactUrl(String planKeyString, String buildNumber, String filePath, Map<String, String> artifactConfig, PlanResultKey planResultKey, ArtifactHandler artifactHandler) {
        if (this.isAgentArtifactHandler(artifactHandler)) {
            return this.getLocalStorageURL(planKeyString, buildNumber, filePath);
        }
        ArtifactDefinitionContextImpl artifactDef = this.getAllureArtifactDef();
        return Optional.ofNullable(artifactHandler.getArtifactLinkDataProvider((Artifact)this.mutableArtifact(planResultKey, artifactDef.getName()), AbstractArtifactHandler.configProvider(artifactConfig))).map(lp -> this.getArtifactUrl(filePath, (ArtifactLinkDataProvider)lp)).orElse(null);
    }

    private String getArtifactUrl(String filePath, ArtifactLinkDataProvider linkProvider) {
        return this.getArtifactFile(filePath, linkProvider);
    }

    @Nullable
    private String getLocalStorageURL(String planKeyString, String buildNumber, String filePath) {
        try {
            File file = this.getLocalStoragePath(planKeyString, buildNumber).resolve(filePath).toFile();
            String fullPath = file.isDirectory() ? new File(file, INDEX_HTML).getAbsolutePath() : file.getAbsolutePath();
            return new File(fullPath).toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new AllurePluginException("Unexpected error", e);
        }
    }

    Collection<Path> downloadAllArtifactsTo(@NotNull ChainResultsSummary chainResultsSummary, File baseDir, @Nullable String artifactName) throws IOException {
        ArrayList<Path> resultsPaths = new ArrayList<Path>();
        for (ChainStageResult stageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary resultsSummary : stageResult.getBuildResults()) {
                LOGGER.info("Found {} artifacts totally for the build {}-{}", new Object[]{Optional.of(resultsSummary.getProducedArtifactLinks()).map(Collection::size).orElse(0), chainResultsSummary.getPlanKey(), chainResultsSummary.getBuildNumber()});
                for (ArtifactLink link : resultsSummary.getProducedArtifactLinks()) {
                    MutableArtifact artifact = link.getArtifact();
                    if (!StringUtils.isEmpty((CharSequence)artifactName) && !artifactName.equals(artifact.getLabel())) continue;
                    LOGGER.info("artifact {} matches the configured artifact name {} for the build {}-{}", new Object[]{artifact.getLabel(), artifactName, chainResultsSummary.getPlanKey(), chainResultsSummary.getBuildNumber()});
                    File stageDir = new File(baseDir, UUID.randomUUID().toString());
                    org.apache.commons.io.FileUtils.forceMkdir((File)stageDir);
                    resultsPaths.add(stageDir.toPath());
                    ArtifactLinkDataProvider dataProvider = this.artifactLinkManager.getArtifactLinkDataProvider((Artifact)artifact);
                    if (dataProvider instanceof FileSystemArtifactLinkDataProvider) {
                        this.downloadAllArtifactsTo((FileSystemArtifactLinkDataProvider)dataProvider, stageDir);
                        continue;
                    }
                    this.downloadAllArtifactsTo(dataProvider, stageDir, "");
                }
            }
        }
        return resultsPaths;
    }

    private void downloadAllArtifactsTo(@NotNull FileSystemArtifactLinkDataProvider dataProvider, File tempDir) {
        Optional.ofNullable(dataProvider.getFile().listFiles()).map(Arrays::asList).ifPresent(list -> list.forEach(file -> {
            try {
                if (file.isFile()) {
                    Files.copy((File)file, (File)Paths.get(tempDir.getPath(), file.getName()).toFile());
                } else if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)".") && !StringUtils.equals((CharSequence)file.getName(), (CharSequence)"..")) {
                    FileUtils.copyDirectory((File)dataProvider.getFile(), (File)tempDir);
                }
            }
            catch (IOException e) {
                this.logAndThrow(e, FAILED_TO_DOWNLOAD_ARTIFACTS_TO + tempDir);
            }
        }));
    }

    private void downloadAllArtifactsTo(ArtifactLinkDataProvider dataProvider, File tempDir, String startFrom) {
        for (ArtifactFileData data : Objects.requireNonNull(dataProvider).listObjects(startFrom)) {
            try {
                if (!(data instanceof TrampolineArtifactFileData)) continue;
                TrampolineArtifactFileData trampolineData = (TrampolineArtifactFileData)data;
                ArtifactFileData delegateData = trampolineData.getDelegate();
                if (delegateData.getFileType().equals((Object)ArtifactFileData.FileType.REGULAR_FILE)) {
                    String fileName = Paths.get(delegateData.getName(), new String[0]).toFile().getName();
                    FileUtils.copyURLToFile((URL)new URL(Objects.requireNonNull(delegateData.getUrl())), (File)Paths.get(tempDir.getPath(), fileName).toFile());
                    continue;
                }
                this.downloadAllArtifactsTo(dataProvider, tempDir, trampolineData.getTag());
            }
            catch (IOException e) {
                this.logAndThrow(e, FAILED_TO_DOWNLOAD_ARTIFACTS_TO + tempDir);
            }
        }
    }

    Optional<AllureBuildResult> uploadReportArtifacts(@NotNull ImmutableChain chain, final @NotNull ChainResultsSummary summary, File reportDir) {
        try {
            final ArtifactDefinitionContextImpl artifact = this.getAllureArtifactDef();
            artifact.setLocation("");
            FileSet sourceFileSet = ArtifactHandlingUtils.createFileSet((File)reportDir, (ArtifactDefinitionContext)artifact, (boolean)true, (org.apache.log4j.Logger)org.apache.log4j.Logger.getLogger(this.getClass()));
            sourceFileSet.setDir(reportDir);
            sourceFileSet.setIncludes(artifact.getCopyPattern());
            Map<String, String> artifactConfig = this.getArtifactHandlersConfig(chain.getBuildDefinition());
            for (final ArtifactHandler artifactHandler : this.getArtifactHandlers()) {
                if (!artifactHandler.canHandleArtifact((ArtifactDefinitionContext)artifact, artifactConfig)) continue;
                if (this.isAgentArtifactHandler(artifactHandler)) {
                    String buildNumber;
                    String planKey = chain.getPlanKey().getKey();
                    File destDir = this.getLocalStoragePath(planKey, buildNumber = String.valueOf(summary.getBuildNumber())).toFile();
                    if (destDir.exists()) {
                        org.apache.commons.io.FileUtils.deleteQuietly((File)destDir);
                    }
                    org.apache.commons.io.FileUtils.moveDirectory((File)reportDir, (File)destDir);
                    return Optional.of(AllureBuildResult.allureBuildResult(true, null).withHandlerClass(artifactHandler.getClass().getName()));
                }
                final ArtifactPublishingConfig artifactPublishingConfig = new ArtifactPublishingConfig(sourceFileSet, artifactConfig);
                String errorMessage = "Unable to publish artifact via " + artifactHandler;
                ArtifactHandlerPublishingResult publishingResult = (ArtifactHandlerPublishingResult)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.NoThrowCallable<ArtifactHandlerPublishingResult>(errorMessage){

                    @NotNull
                    public ArtifactHandlerPublishingResult call() {
                        try {
                            return artifactHandler.publish((ResultKey)summary.getPlanResultKey(), (ArtifactDefinitionContext)artifact, artifactPublishingConfig);
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to publish Allure Report using handler " + artifactHandler.getClass().getName(), (Throwable)e);
                            return ArtifactHandlerPublishingResultImpl.failure();
                        }
                    }
                });
                if (publishingResult == null) continue;
                publishingResult.setArtifactHandlerKey(artifactHandler.getModuleDescriptor().getCompleteKey());
                return Optional.of(AllureBuildResult.allureBuildResult(publishingResult.isSuccessful(), null).withHandlerClass(artifactHandler.getClass().getName()));
            }
        }
        catch (Exception e) {
            String message = "Failed to publish Allure Report from directory " + reportDir;
            LOGGER.error(message, (Throwable)e);
            return Optional.of(AllureBuildResult.allureBuildResult(false, message + "\n" + ExceptionUtil.stackTraceToString(e)));
        }
        return Optional.empty();
    }

    private Path getLocalStoragePath(String planKey, String buildNumber) {
        return Paths.get(this.settingsManager.getSettings().getLocalStoragePath(), REPORTS_SUBDIR, planKey, buildNumber);
    }

    private void logAndThrow(Exception e, String message) {
        LOGGER.error(message, (Throwable)e);
        throw new AllurePluginException(message, e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private String getArtifactFile(String filePath, ArtifactLinkDataProvider linkProvider) {
        String fixedFilePath = filePath.replaceFirst("^/", "");
        if (linkProvider instanceof FileSystemArtifactLinkDataProvider) {
            return Objects.requireNonNull(linkProvider.getRootUrl()).replaceFirst("BASE_URL", this.getBaseUrl().build(new Object[0]).toString()).replace(INDEX_HTML, StringUtils.isEmpty((CharSequence)fixedFilePath) ? INDEX_HTML : fixedFilePath);
        }
        Iterable datas = linkProvider.listObjects(fixedFilePath);
        if (Iterables.size((Iterable)datas) == 1) {
            ArtifactFileData data = (ArtifactFileData)datas.iterator().next();
            if (!(data instanceof TrampolineArtifactFileData)) return this.getBambooArtifactUrl(data);
            TrampolineArtifactFileData trampolineData = (TrampolineArtifactFileData)data;
            if (!(data = trampolineData.getDelegate()).getFileType().equals((Object)ArtifactFileData.FileType.REGULAR_FILE)) return null;
            return data.getUrl();
        }
        if (Iterables.size((Iterable)datas) <= 1) return null;
        return this.getArtifactFile(INDEX_HTML, linkProvider);
    }

    private String getBambooArtifactUrl(ArtifactFileData data) {
        return Optional.ofNullable(data.getUrl()).map(url -> url.startsWith("/") ? this.getBaseUrl().path(url).build(new Object[0]).toString() : url).orElse(null);
    }

    private UriBuilder getBaseUrl() {
        return UriBuilder.fromPath((String)this.appProperties.getBaseUrl(UrlMode.ABSOLUTE));
    }

    @NotNull
    private ArtifactDefinitionContextImpl getAllureArtifactDef() {
        ArtifactDefinitionContextImpl artifact = new ArtifactDefinitionContextImpl("allure-report", false, SecureToken.create());
        artifact.setCopyPattern("**/**");
        return artifact;
    }

    @NotNull
    private Map<String, String> getArtifactHandlersConfig(BuildDefinition buildDefinition) {
        Map config = this.artifactHandlersService.getRuntimeConfiguration();
        Map planCustomConfiguration = buildDefinition.getCustomConfiguration();
        if (ArtifactHandlingUtils.isCustomArtifactHandlingConfigured((Map)planCustomConfiguration)) {
            Collector<Map.Entry, ?, Map<String, String>> toMap = Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
            Predicate<Map.Entry> isArtifactHandler = e -> ((String)e.getKey()).startsWith("custom.artifactHandlers.");
            Predicate<Map.Entry> isNotHandlerSwitch = e -> ArtifactHandlerModuleDescriptorImpl.SHARED_NON_SHARED_ONOFF_OPTION_NAME.values().stream().noneMatch(o -> ((String)e.getKey()).endsWith((String)o));
            config.putAll(planCustomConfiguration.entrySet().stream().filter(isArtifactHandler).collect(toMap));
            return config.entrySet().stream().filter(isArtifactHandler).filter(isNotHandlerSwitch).collect(toMap);
        }
        return config;
    }

    @NotNull
    private MutableArtifact mutableArtifact(PlanResultKey planResultKey, String name) {
        return new MutableArtifactImpl(name, planResultKey, null, false, Long.valueOf(0L));
    }

    private List<ArtifactHandler> getArtifactHandlers() {
        Predicate predicate = new ModuleOfClassPredicate(ArtifactHandler.class).and((Predicate)new EnabledModulePredicate());
        return ImmutableList.copyOf((Collection)this.pluginAccessor.getModules(predicate));
    }

    private boolean isAgentArtifactHandler(ArtifactHandler artifactHandler) {
        return artifactHandler instanceof BambooRemoteArtifactHandler || artifactHandler instanceof AgentLocalArtifactHandler;
    }

    private <T extends ArtifactHandler> Optional<T> getArtifactHandlerByClassName(String className) {
        AtomicReference predicate = new AtomicReference();
        return Optional.ofNullable(className).map(clazz -> {
            try {
                Class<?> aClass = Class.forName(clazz);
                predicate.set(new ModuleOfClassPredicate(aClass).and((Predicate)new EnabledModulePredicate()));
                return this.pluginAccessor.getModules((Predicate)predicate.get()).stream().findAny().orElse(null);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Failed to find artifact handler for class name " + className, (Throwable)e);
                return null;
            }
        });
    }
}

