/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.bamboo;

import io.qameta.allure.bamboo.AllureCommandLineSupport;
import io.qameta.allure.bamboo.AllureDownloader;
import io.qameta.allure.bamboo.AllureExecutable;
import io.qameta.allure.bamboo.AllureGlobalConfig;
import io.qameta.allure.bamboo.BambooExecutablesManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllureExecutableProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllureExecutableProvider.class);
    static final String DEFAULT_VERSION = "2.30.0";
    static final String DEFAULT_PATH = "/tmp/allure/2.30.0";
    static final String BIN = "bin";
    private static final Pattern EXEC_NAME_PATTERN = Pattern.compile("[^\\d]*(\\d[0-9\\.]{2,}[a-zA-Z0-9\\-]*)$");
    private final BambooExecutablesManager bambooExecutablesManager;
    private final AllureDownloader allureDownloader;
    private final AllureCommandLineSupport cmdLine;

    public AllureExecutableProvider(BambooExecutablesManager bambooExecutablesManager, AllureDownloader allureDownloader, AllureCommandLineSupport cmdLine) {
        this.bambooExecutablesManager = Objects.requireNonNull(bambooExecutablesManager);
        this.allureDownloader = Objects.requireNonNull(allureDownloader);
        this.cmdLine = Objects.requireNonNull(cmdLine);
    }

    Optional<AllureExecutable> provide(boolean isDownloadEnabled, String executableName) {
        return this.bambooExecutablesManager.getExecutableByName(executableName).map(allureHomeDir -> {
            LOGGER.info("Found allure executable by name '{}': '{}'", (Object)executableName, allureHomeDir);
            Path cmdPath = Paths.get(allureHomeDir, BIN, this.getAllureExecutableName());
            AllureExecutable executable = new AllureExecutable(cmdPath, this.cmdLine);
            LOGGER.info("Checking the existence of the command path for executable '{}': '{}'", (Object)executableName, (Object)cmdPath);
            boolean commandExists = this.cmdLine.hasCommand(cmdPath.toString());
            LOGGER.info("System has command for executable '{}': {}, downloadEnabled={}", new Object[]{executableName, commandExists, isDownloadEnabled});
            if (commandExists) {
                return executable;
            }
            if (isDownloadEnabled) {
                Matcher nameMatcher = EXEC_NAME_PATTERN.matcher(executableName);
                return this.allureDownloader.downloadAndExtractAllureTo((String)allureHomeDir, nameMatcher.matches() ? nameMatcher.group(1) : DEFAULT_VERSION).map(path -> executable).orElse(null);
            }
            return null;
        });
    }

    Optional<AllureExecutable> provide(AllureGlobalConfig globalConfig, String executableName) {
        return this.provide(globalConfig.isDownloadEnabled(), executableName);
    }

    @NotNull
    private String getAllureExecutableName() {
        return this.cmdLine.isWindows() ? "allure.bat" : "allure";
    }
}

